/*
 *  Version: 1.0
 *
 *  The contents of this file are subject to the OpenVPMS License Version
 *  1.0 (the 'License'); you may not use this file except in compliance with
 *  the License. You may obtain a copy of the License at
 *  http://www.openvpms.org/license/
 *
 *  Software distributed under the License is distributed on an 'AS IS' basis,
 *  WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 *  for the specific language governing rights and limitations under the
 *  License.
 *
 *  Copyright 2006 (C) OpenVPMS Ltd. All Rights Reserved.
 *
 *  $Id$
 */

package org.openvpms.web.component.workflow;


/**
 * Event generated by {@link Task}s.
 *
 * @author <a href="mailto:support@openvpms.org">OpenVPMS Team</a>
 * @version $LastChangedDate: 2006-05-02 05:16:31Z $
 */
public class TaskEvent {

    /**
     * The event type.
     */
    public enum Type {
        SKIPPED, COMPLETED, CANCELLED
    }

    /**
     * The event type.
     */
    private final Type type;

    /**
     * The task that generated the event.
     */
    private final Task task;


    /**
     * Creates a new <tt>TaskEvent</tt>.
     *
     * @param type the event type
     * @param task the task that generated the event
     */
    public TaskEvent(Type type, Task task) {
        this.type = type;
        this.task = task;
    }

    /**
     * Returns the event type.
     *
     * @return the event type
     */
    public Type getType() {
        return type;
    }

    /**
     * Returns the task that generated the event.
     *
     * @return the task that generated the event
     */
    public Task getTask() {
        return task;
    }

}
