/*
 *  Version: 1.0
 *
 *  The contents of this file are subject to the OpenVPMS License Version
 *  1.0 (the 'License'); you may not use this file except in compliance with
 *  the License. You may obtain a copy of the License at
 *  http://www.openvpms.org/license/
 *
 *  Software distributed under the License is distributed on an 'AS IS' basis,
 *  WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 *  for the specific language governing rights and limitations under the
 *  License.
 *
 *  Copyright 2007 (C) OpenVPMS Ltd. All Rights Reserved.
 *
 *  $Id$
 */

package org.openvpms.web.component.workflow;


/**
 * A {@link ConditionalTask} that creates a new object if it doesn't exist
 * in the context.
 *
 * @author <a href="mailto:support@openvpms.org">OpenVPMS Team</a>
 * @version $LastChangedDate: 2006-05-02 05:16:31Z $
 */
public class ConditionalCreateTask extends ExistsTask {

    /**
     * Creates a new <tt>ConditionalCreateTask</tt>.
     *
     * @param shortName the short name of the object to create.
     */
    public ConditionalCreateTask(String shortName) {
        super(shortName, false, new CreateIMObjectTask(shortName));
    }
}
