/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.im.table.act;

import org.openvpms.component.business.domain.im.act.ActRelationship;
import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.relationship.DelegatingIMObjectRelationshipTargetTableModel;


/**
 * A table model for {@link ActRelationship}s that models the target acts
 * referred to by the relationships. The model for the target acts is determined
 * by subclasses.
 *
 * @author Tim Anderson
 */
public abstract class AbstractActRelationshipTableModel<T extends Act>
        extends DelegatingIMObjectRelationshipTargetTableModel<ActRelationship, T> {

}
