/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.im.table;

import org.openvpms.component.model.object.IMObject;


/**
 * Paged, sortable table of {@link IMObject}s.
 *
 * @author Tim Anderson
 */
public class PagedIMObjectTableModel<T extends IMObject>
        extends PagedIMTableModel<T, T> implements IMObjectTableModel<T> {


    /**
     * Constructs a {@link PagedIMObjectTableModel}.
     *
     * @param model the underlying table model.
     */
    public PagedIMObjectTableModel(IMObjectTableModel<T> model) {
        super(model);
    }

}
