/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.im.list;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;


/**
 * List cell renderer that display's an {@link IMObject}'s name or description.
 *
 * @author Tim Anderson
 */
public class IMObjectListCellRenderer extends AllNoneListCellRenderer<IMObject> {

    /**
     * A renderer that renders the object's name.
     */
    public static final IMObjectListCellRenderer NAME = new IMObjectListCellRenderer(Node.NAME);

    /**
     * A renderer that renders the object's description.
     */
    public static final IMObjectListCellRenderer DESCRIPTION = new IMObjectListCellRenderer(Node.DESCRIPTION);

    /**
     * The node to render.
     */
    private final Node node;

    /**
     * Constructs an {@link IMObjectListCellRenderer}.
     *
     * @param node the node to render
     */
    protected IMObjectListCellRenderer(Node node) {
        super(IMObject.class);
        this.node = node;
    }

    /**
     * Renders an object.
     *
     * @param list   the list component
     * @param object the object to render. May be {@code null}
     * @param index  the object index
     * @return the rendered object
     */
    protected Object getComponent(Component list, IMObject object, int index) {
        return toString(list, object, index);
    }

    /**
     * Returns the string form of the object at the specified cell.
     *
     * @param list   the list component
     * @param object the object to render. May be {@code null}
     * @param index  the object index
     * @return the text. May be {@code null}
     */
    @Override
    protected String toString(Component list, IMObject object, int index) {
        if (object != null) {
            return (node == Node.NAME) ? object.getName() : object.getDescription();
        }
        return null;
    }

    /**
     * The nodes that may be rendered.
     */
    public enum Node {
        NAME, DESCRIPTION
    }
}
