/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.oauth;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ClientRegistrationRepositoryImpl
implements ClientRegistrationRepository {
    private final PracticeService practiceService;
    private final PasswordEncryptor encryptor;
    private final ArchetypeService service;
    private final LookupService lookupService;
    private static final char PATH_DELIMITER = '/';

    public ClientRegistrationRepositoryImpl(PracticeService practiceService, PasswordEncryptor encryptor, IArchetypeService service, LookupService lookupService) {
        this.practiceService = practiceService;
        this.encryptor = encryptor;
        this.service = service;
        this.lookupService = lookupService;
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        ClientRegistration registration = null;
        Lookup lookup = this.lookupService.getLookup("lookup.oauth2ClientRegistration", registrationId);
        if (lookup != null) {
            if ("gmail".equals(registrationId)) {
                registration = this.createGmailRegistration(lookup);
            } else if ("outlook".equals(registrationId)) {
                registration = this.createOutlookRegistration(lookup);
            }
        }
        return registration;
    }

    public String getRedirectURI(String registrationId, HttpServletRequest request) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("registrationId", registrationId);
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        String path = uriComponents.getPath();
        if (!StringUtils.isEmpty((String)path) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        uriVariables.put("basePath", path != null ? path : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        return UriComponentsBuilder.fromUriString((String)this.getRedirectURITemplate()).buildAndExpand(uriVariables).toUriString();
    }

    private String getRedirectURITemplate() {
        String baseURL = this.practiceService.getBaseURL();
        StringBuilder redirectUri = new StringBuilder();
        if (!StringUtils.isEmpty((String)baseURL)) {
            redirectUri.append(baseURL);
            if (!baseURL.endsWith("/")) {
                redirectUri.append('/');
            }
        } else {
            redirectUri.append("{baseScheme}://{baseHost}{basePort}{basePath}/");
        }
        redirectUri.append("oauth2/code/{registrationId}");
        return redirectUri.toString();
    }

    private ClientRegistration createGmailRegistration(Lookup lookup) {
        IMObjectBean bean = this.service.getBean((IMObject)lookup);
        return this.populate(CommonOAuth2Provider.GOOGLE.getBuilder("gmail"), bean).authorizationUri("https://accounts.google.com/o/oauth2/v2/auth?access_type=offline").scope(new String[]{"openid", "profile", "email", "https://mail.google.com/"}).build();
    }

    private ClientRegistration createOutlookRegistration(Lookup lookup) {
        IMObjectBean bean = this.service.getBean((IMObject)lookup);
        String tenantId = bean.getString("tenantId");
        return this.populate(ClientRegistration.withRegistrationId((String)"outlook"), bean).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationUri("https://login.microsoftonline.com/" + tenantId + "/oauth2/v2.0/authorize?prompt=consent").tokenUri("https://login.microsoftonline.com/" + tenantId + "/oauth2/v2.0/token").jwkSetUri("https://login.microsoftonline.com/" + tenantId + "/discovery/v2.0/keys").userInfoUri("https://graph.microsoft.com/oidc/userinfo").userNameAttributeName("sub").scope(new String[]{"openid", "offline_access", "email", "profile", "https://outlook.office.com/IMAP.AccessAsUser.All", "https://outlook.office.com/SMTP.Send"}).build();
    }

    private ClientRegistration.Builder populate(ClientRegistration.Builder builder, IMObjectBean bean) {
        String encryptedSecret = bean.getString("clientSecret");
        String clientSecret = encryptedSecret != null ? this.encryptor.decrypt(encryptedSecret) : null;
        String redirectUri = this.getRedirectURITemplate();
        return builder.clientId(bean.getString("clientId")).clientSecret(clientSecret).redirectUri(redirectUri);
    }
}

