/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.DocumentGenerator;
import org.openvpms.web.component.im.doc.DocumentGeneratorFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.component.workspace.DocumentActActions;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class DocumentCRUDWindow
extends ActCRUDWindow<DocumentAct> {
    private static final String REFRESH_ID = "button.refresh";
    private static final String EXTERNAL_EDIT_ID = "button.externaledit";

    public DocumentCRUDWindow(Archetypes<DocumentAct> archetypes, Context context, HelpContext help) {
        this(archetypes, new DocumentActActions(), context, help);
    }

    public DocumentCRUDWindow(Archetypes<DocumentAct> archetypes, DocumentActActions actions, Context context, HelpContext help) {
        super(archetypes, actions, context, help);
    }

    @Override
    protected DocumentActActions getActions() {
        return (DocumentActActions)super.getActions();
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(REFRESH_ID, this::onRefresh);
        buttons.add(EXTERNAL_EDIT_ID, this::onExternalEdit);
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        this.enablePrintPreview(buttons, enable);
        boolean enableRefresh = enable && this.canRefresh();
        buttons.setEnabled(REFRESH_ID, enableRefresh);
        buttons.setEnabled(EXTERNAL_EDIT_ID, enable && this.getActions().canExternalEdit((DocumentAct)this.getObject()));
    }

    @Override
    protected void print(DocumentAct object) {
        if (object.getDocument() == null) {
            if (this.canRefresh()) {
                this.refresh(object, false, () -> DocumentCRUDWindow.super.print((Act)object));
            } else if (this.isGenerated(object)) {
                super.print(object);
            } else {
                InformationDialog.show((String)Messages.get((String)"printdialog.title"), (String)Messages.format((String)"document.print.none", (Object[])new Object[]{this.getDisplayName((IMObject)object)}));
            }
        } else {
            super.print(object);
        }
    }

    @Override
    protected void mail(DocumentAct object) {
        if (object.getDocument() == null) {
            if (this.canRefresh()) {
                this.refresh(object, false, () -> DocumentCRUDWindow.super.mail((Act)object));
            } else if (this.isGenerated(object)) {
                super.mail(object);
            } else {
                InformationDialog.show((String)Messages.get((String)"mail.title"), (String)Messages.format((String)"mail.document.none", (Object[])new Object[]{this.getDisplayName((IMObject)object)}));
            }
        } else {
            super.mail(object);
        }
    }

    private boolean isGenerated(DocumentAct object) {
        IMObjectBean bean = this.getBean((IMObject)object);
        return bean.hasNode("documentTemplate") || bean.hasNode("investigationType");
    }

    private void onRefresh() {
        final DocumentAct act = (DocumentAct)IMObjectHelper.reload(this.getObject());
        if (act == null) {
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getArchetypes().getDisplayName()}));
        } else {
            Entity documentTemplate;
            IMObjectBean bean;
            String name = act.getFileName();
            if (name == null && (bean = this.getBean((IMObject)act)).hasNode("documentTemplate") && (documentTemplate = (Entity)bean.getTarget("documentTemplate", Entity.class)) != null) {
                name = documentTemplate.getName();
            }
            if (name == null) {
                name = Messages.get((String)"imobject.none");
            }
            final RefreshDialog dialog = new RefreshDialog(act, name, this.getHelpContext());
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    DocumentCRUDWindow.this.refresh(act, dialog.version(), null);
                }
            });
            dialog.show();
        }
    }

    private void refresh(final DocumentAct act, boolean version, final Runnable callback) {
        DocumentGeneratorFactory factory = ServiceHelper.getBean(DocumentGeneratorFactory.class);
        DocumentGenerator generator = factory.create(act, this.getContext(), this.getHelpContext(), new DocumentGenerator.AbstractListener(){

            @Override
            public void generated(Document document) {
                DocumentCRUDWindow.this.onSaved(act, false);
                if (callback != null) {
                    callback.run();
                }
            }
        });
        generator.generate(true, version);
    }

    private void onExternalEdit() {
        final DocumentAct act = (DocumentAct)IMObjectHelper.reload(this.getObject());
        if (act == null) {
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getArchetypes().getDisplayName()}));
        } else if (act.getDocument() != null) {
            this.getActions().externalEdit(act);
        } else {
            DocumentGeneratorFactory factory = ServiceHelper.getBean(DocumentGeneratorFactory.class);
            DocumentGenerator generator = factory.create(act, this.getContext(), this.getHelpContext(), new DocumentGenerator.AbstractListener(){

                @Override
                public void generated(Document document) {
                    DocumentCRUDWindow.this.onSaved(act, false);
                    DocumentActActions actions = DocumentCRUDWindow.this.getActions();
                    if (actions.canExternalEdit(act)) {
                        actions.externalEdit(act);
                    }
                }
            });
            generator.generate(true, true);
        }
    }

    private boolean canRefresh() {
        DocumentAct act = (DocumentAct)this.getObject();
        return act != null && this.getActions().canRefresh(act);
    }

    private class RefreshDialog
    extends ConfirmationDialog {
        private CheckBox version;

        public RefreshDialog(DocumentAct act, String name, HelpContext help) {
            super(Messages.get((String)"document.refresh.title"), Messages.format((String)"document.refresh.message", (Object[])new Object[]{name}), help.subtopic("refresh"));
            DocumentRules rules = new DocumentRules((ArchetypeService)ServiceHelper.getArchetypeService());
            if (act.getDocument() != null && rules.supportsVersions(act)) {
                this.version = CheckBoxFactory.create((String)"document.refresh.version", (boolean)true);
            }
        }

        public boolean version() {
            return this.version != null && this.version.isSelected();
        }

        protected void doLayout() {
            if (this.version != null) {
                Label content = LabelFactory.create((boolean)true, (boolean)true);
                content.setText(this.getMessage());
                Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{content, this.version});
                Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{column});
                this.getLayout().add((Component)row);
            } else {
                super.doLayout();
            }
        }
    }
}

