/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.DocFormats;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.servlet.ServletHelper;
import org.openvpms.web.echo.util.LinkClicker;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.webdav.milton.DocumentSessionManager;
import org.openvpms.web.webdav.resource.EditableDocuments;
import org.openvpms.web.webdav.session.Session;

public class DocumentActActions
extends ActActions<DocumentAct> {
    public boolean canRefresh(DocumentAct act) {
        IMObjectBean bean;
        boolean refresh = false;
        if (!this.isLocked(act) && (bean = ServiceHelper.getArchetypeService().getBean((IMObject)act)).hasNode("documentTemplate") && bean.hasNode("document")) {
            refresh = true;
        }
        return refresh;
    }

    public boolean canExternalEdit(Act act) {
        return act instanceof DocumentAct && this.canExternalEdit((DocumentAct)act);
    }

    public boolean canExternalEdit(DocumentAct act) {
        if (this.canEdit(act)) {
            EditableDocuments documents = ServiceHelper.getBean(EditableDocuments.class);
            return documents.canEdit(act);
        }
        return false;
    }

    public boolean canExternalEdit(Entity template) {
        DocumentAct act = this.getDocumentAct(template);
        return act != null && this.canExternalEdit(act);
    }

    public void externalEdit(final DocumentAct act) {
        if (this.canExternalEdit(act) && act.getDocument() != null) {
            if (DocFormats.hasExtension((String)act.getFileName(), (String[])new String[]{"doc"})) {
                String title = Messages.get((String)"document.edit.wordinopenoffice.title");
                String message = Messages.get((String)"document.edit.wordinopenoffice.message");
                ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        DocumentActActions.this.onExternalEdit(act);
                    }
                });
            } else {
                this.onExternalEdit(act);
            }
        }
    }

    public void externalEdit(Entity template) {
        DocumentAct act = this.getDocumentAct(template);
        if (act != null) {
            this.externalEdit(act);
        }
    }

    protected void onExternalEdit(DocumentAct act) {
        DocumentSessionManager sessions = ServiceHelper.getBean(DocumentSessionManager.class);
        Session session = sessions.create(act);
        String url = "jnlp:" + ServletHelper.getContextURL() + "/externaledit?session=" + session.getSessionId() + "&id=" + act.getId();
        ApplicationInstance.getActive().enqueueCommand((Command)new LinkClicker(url));
    }

    private DocumentAct getDocumentAct(Entity template) {
        DocumentAct result = null;
        if (TypeHelper.isA((IMObject)template, (String[])new String[]{"entity.documentTemplate", "entity.documentTemplateEmailSystem", "entity.documentTemplateEmailUser"})) {
            DocumentTemplate documentTemplate = new DocumentTemplate(template, (ArchetypeService)ServiceHelper.getArchetypeService());
            result = documentTemplate.getDocumentAct();
        }
        return result;
    }
}

