/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.workspace.AbstractCRUDWorkspace;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.factory.SplitPaneFactory;

public abstract class BrowserCRUDWorkspace<Parent extends IMObject, Child extends IMObject>
extends AbstractCRUDWorkspace<Parent, Child> {
    private Browser<Child> browser;
    private Component workspace;

    public BrowserCRUDWorkspace(String id, Context context) {
        this(id, context, true);
    }

    public BrowserCRUDWorkspace(String id, Context context, boolean showSelector) {
        super(id, context, showSelector);
    }

    public BrowserCRUDWorkspace(String id, Archetypes<Parent> archetypes, Context context) {
        this(id, archetypes, null, context);
    }

    public BrowserCRUDWorkspace(String id, Archetypes<Parent> archetypes, Archetypes<Child> childArchetypes, Context context) {
        this(id, archetypes, childArchetypes, context, true);
    }

    public BrowserCRUDWorkspace(String id, Archetypes<Parent> archetypes, Archetypes<Child> childArchetypes, Context context, boolean showSelector) {
        super(id, archetypes, childArchetypes, context, showSelector);
    }

    @Override
    public void setObject(Parent object) {
        super.setObject(object);
        this.layoutWorkspace(false);
    }

    protected abstract Browser<Child> createBrowser();

    protected Browser<Child> getBrowser() {
        return this.browser;
    }

    protected void setBrowser(Browser<Child> browser) {
        if (browser != null) {
            browser.addBrowserListener(new BrowserListener<Child>(){

                @Override
                public void query() {
                    BrowserCRUDWorkspace.this.onBrowserQuery();
                }

                @Override
                public void selected(Child object) {
                    BrowserCRUDWorkspace.this.onBrowserSelected(object);
                }

                @Override
                public void browsed(Child object) {
                    BrowserCRUDWorkspace.this.onBrowserViewed(object);
                }
            });
        }
        this.browser = browser;
    }

    protected void onBrowserSelected(Child object) {
        this.getCRUDWindow().setObject(object);
    }

    protected void onBrowserViewed(Child object) {
        this.getCRUDWindow().setObject(object);
    }

    @Override
    protected void onSaved(Child object, boolean isNew) {
        this.refreshBrowser();
        CRUDWindow window = this.getCRUDWindow();
        if (!this.browser.getObjects().isEmpty()) {
            this.browser.setSelected(object);
            window.setObject(object);
        } else {
            window.setObject(null);
        }
        if (this.updateSummaryOnChildUpdate()) {
            this.firePropertyChange("summary", null, null);
        }
        this.browser.setFocusOnResults();
    }

    @Override
    protected void onDeleted(Child object) {
        this.refreshBrowser();
        if (this.updateSummaryOnChildUpdate()) {
            this.firePropertyChange("summary", null, null);
        }
        this.browser.setFocusOnResults();
    }

    @Override
    protected void onRefresh(Child object) {
        this.refreshBrowser();
        if (object != null && object.isNew()) {
            object = null;
        }
        this.browser.setSelected(object);
        if (this.updateSummaryOnChildUpdate()) {
            this.firePropertyChange("summary", null, null);
        }
        CRUDWindow window = this.getCRUDWindow();
        if (Objects.equals(this.browser.getSelected(), object)) {
            window.setObject((IMObject)this.browser.getSelected());
        } else {
            window.setObject(null);
        }
        this.browser.setFocusOnResults();
    }

    @Override
    protected void doLayout(Component container) {
        Object object;
        Object latest = this.getLatest();
        if (latest != (object = this.getObject())) {
            this.setObject((Parent)latest);
        } else {
            this.layoutWorkspace(true);
        }
    }

    protected void layoutWorkspace(boolean refresh) {
        Object parent = this.getObject();
        if (parent != null || this.isParentOptional()) {
            Browser<Child> browser = this.getBrowser();
            if (refresh && browser != null) {
                this.setCRUDWindow(this.getCRUDWindow());
                this.setWorkspace(this.getWorkspace());
                browser.query();
            } else {
                this.recreateWorkspace();
            }
        } else {
            this.setBrowser(null);
            this.setCRUDWindow(null);
            if (this.workspace != null) {
                this.getRootComponent().remove(this.workspace);
                this.workspace = null;
            }
        }
    }

    protected void recreateWorkspace() {
        this.setBrowser(this.createBrowser());
        this.setCRUDWindow(this.createCRUDWindow());
        this.setWorkspace(this.createWorkspace());
    }

    protected void setWorkspace(Component workspace) {
        SplitPane root = this.getRootComponent();
        if (this.workspace != null) {
            root.remove(this.workspace);
        }
        this.workspace = workspace;
        root.add(this.workspace);
    }

    protected Component getWorkspace() {
        return this.workspace;
    }

    protected Component createWorkspace() {
        return SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.getBrowser().getComponent(), this.getCRUDWindow().getComponent()});
    }

    protected boolean updateSummaryOnChildUpdate() {
        return true;
    }

    protected boolean isParentOptional() {
        return false;
    }

    protected boolean selectFirstObjectOnQuery() {
        return true;
    }

    protected void onBrowserQuery() {
        if (this.selectFirstObjectOnQuery()) {
            List<Child> objects = this.browser.getObjects();
            CRUDWindow window = this.getCRUDWindow();
            if (!objects.isEmpty()) {
                IMObject current = (IMObject)objects.get(0);
                this.browser.setSelected(current);
                window.setObject(current);
            } else {
                window.setObject(null);
            }
        }
    }

    private void refreshBrowser() {
        BrowserState state = this.browser.getBrowserState();
        if (state != null && !state.isEmpty()) {
            this.browser.setBrowserState(state);
        } else {
            this.browser.query();
        }
    }
}

