/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.util.DoubleClickMonitor;

public class BrowserCRUDWindow<T extends IMObject> {
    private final boolean trackClick;
    private final DoubleClickMonitor click = new DoubleClickMonitor();
    private Browser<T> browser;
    private AbstractCRUDWindow<T> window;

    protected BrowserCRUDWindow() {
        this.trackClick = true;
    }

    public BrowserCRUDWindow(Browser<T> browser, AbstractCRUDWindow<T> window) {
        this(browser, window, true);
    }

    public BrowserCRUDWindow(Browser<T> browser, AbstractCRUDWindow<T> window, boolean trackClick) {
        this.trackClick = trackClick;
        this.setBrowser(browser);
        this.setWindow(window);
    }

    public Browser<T> getBrowser() {
        return this.browser;
    }

    public CRUDWindow<T> getWindow() {
        return this.window;
    }

    public void setSelected(T object) {
        this.browser.setSelected(object);
        if (this.window != null) {
            this.select((IMObject)this.browser.getSelected());
        }
    }

    protected void setBrowser(Browser<T> browser) {
        this.browser = browser;
        browser.addBrowserListener(this.createListener());
        if (this.window != null) {
            this.select((IMObject)browser.getSelected());
        }
    }

    protected BrowserListener<T> createListener() {
        return new BrowserListener<T>(){

            @Override
            public void query() {
                BrowserCRUDWindow.this.onQuery();
            }

            @Override
            public void selected(T object) {
                BrowserCRUDWindow.this.onSelected(object);
            }

            @Override
            public void browsed(T object) {
                BrowserCRUDWindow.this.onBrowsed(object);
            }
        };
    }

    protected void setWindow(AbstractCRUDWindow<T> window) {
        this.window = window;
        window.setListener(new CRUDWindowListener<T>(){

            @Override
            public void saved(T object, boolean isNew) {
                BrowserCRUDWindow.this.onSaved(object, isNew);
            }

            @Override
            public void deleted(T object) {
                BrowserCRUDWindow.this.onDeleted(object);
            }

            @Override
            public void refresh(T object) {
                BrowserCRUDWindow.this.onRefresh(object);
            }
        });
        if (this.browser != null) {
            window.setObject((IMObject)this.browser.getSelected());
        }
    }

    protected void onQuery() {
    }

    protected void onSelected(T object) {
        this.select(object);
        if (this.trackClick && this.click.isDoubleClick((Object)object.getId())) {
            this.onDoubleClick();
        }
    }

    protected void select(T object) {
        if (this.window.getObject() != object) {
            this.window.setObject(object);
        }
    }

    protected void onDoubleClick() {
        if (this.window.canEdit()) {
            this.window.edit();
        }
    }

    protected void onBrowsed(T object) {
        this.select(object);
    }

    protected void onSaved(T object, boolean isNew) {
        this.refreshBrowser(object);
    }

    protected void onDeleted(T object) {
        this.refreshBrowser(null);
    }

    protected void onRefresh(T object) {
        if (object != null && object.isNew()) {
            this.refreshBrowser(null);
        } else {
            this.refreshBrowser(object);
        }
    }

    protected void refreshBrowser(T object) {
        this.browser.query();
        if (this.browser.setSelected(object)) {
            if (this.window.getObject() != object) {
                this.window.setObject(object);
            }
        } else {
            this.window.setObject(null);
        }
    }
}

