/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import java.util.function.Consumer;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class ActPoster<T extends Act> {
    private final T act;
    private final ActActions<T> actions;
    private final HelpContext help;
    private final ActionFactory factory;

    public ActPoster(T act, ActActions<T> actions, HelpContext help) {
        this.act = act;
        this.actions = actions;
        this.help = help;
        this.factory = ServiceHelper.getBean(ActionFactory.class);
    }

    public void post(Consumer<T> listener) {
        this.factory.newAction().withObject(this.act).call((object, completionListener) -> {
            if (this.actions.canPost((Act)object)) {
                this.confirmPost((T)object, this.help, (Consumer<ActionStatus>)completionListener);
            } else {
                completionListener.accept(ActionStatus.success());
            }
        }).onFailure(status -> listener.accept(this.act)).onSuccess(() -> listener.accept(this.act)).runOnce();
    }

    protected void confirmPost(T act, HelpContext help, Consumer<ActionStatus> listener) {
        String displayName = DescriptorHelper.getDisplayName(act, (ArchetypeService)ServiceHelper.getArchetypeService());
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("act.post.title", new Object[]{displayName})).messageKey("act.post.message", new Object[]{displayName})).help(help)).okCancel()).ok(() -> this.postConfirmed(act, listener))).cancel(() -> listener.accept(ActionStatus.success()))).show();
    }

    protected void postConfirmed(T act, Consumer<ActionStatus> listener) {
        try {
            if (this.actions.canPost(act)) {
                this.post(act, listener);
            } else {
                listener.accept(ActionStatus.success());
            }
        }
        catch (Throwable exception) {
            listener.accept(ActionStatus.failed(exception));
        }
    }

    protected void post(T act, Consumer<ActionStatus> listener) {
        this.actions.post(act);
        listener.accept(ActionStatus.success());
    }
}

