/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.service.logo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.doc.LogoService;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LogoServlet
extends HttpServlet {
    private final ThreadLocal<Logo> current = new ThreadLocal();
    private LogoService logoService;
    private PracticeService practiceService;
    private static final String DEFAULT_LOGO = "/images/openvpms.png";
    private static final String DEFAULT_MIME_TYPE = "image/png";
    private static final Logger log = LoggerFactory.getLogger(LogoServlet.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.logoService = (LogoService)context.getBean(LogoService.class);
        this.practiceService = (PracticeService)context.getBean(PracticeService.class);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.current.set(this.getLogo());
            super.service(request, response);
        }
        finally {
            this.current.remove();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block18: {
            try {
                Logo logo = this.current.get();
                if (logo != null) {
                    response.setContentType(logo.getMimeType());
                    int length = logo.getSize();
                    if (length > 0) {
                        response.setContentLength(length);
                    }
                    try (InputStream stream = logo.getContent();){
                        IOUtils.copy((InputStream)stream, (OutputStream)response.getOutputStream());
                        break block18;
                    }
                    catch (IOException exception) {
                        response.sendError(404);
                    }
                    break block18;
                }
                response.sendError(404);
            }
            catch (Exception exception) {
                response.sendError(500);
            }
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        Logo logo = this.current.get();
        return logo != null ? logo.getLastModified() : -1L;
    }

    private Logo getLogo() {
        Logo result = this.getPracticeLogo();
        if (result == null) {
            result = this.getDefaultLogo();
        }
        return result;
    }

    private Logo getPracticeLogo() {
        PracticeLogo result = null;
        try {
            ImageService.Image image;
            Party practice = this.practiceService.getPractice();
            if (practice != null && (image = this.logoService.getImage((Entity)practice)) != null) {
                result = new PracticeLogo(image);
            }
        }
        catch (Exception exception) {
            log.error("Failed to retrieve practice logo: {}", (Object)exception.getMessage());
        }
        return result;
    }

    private Logo getDefaultLogo() {
        DefaultLogo result = null;
        try {
            URL url = this.getServletContext().getResource(DEFAULT_LOGO);
            if (url != null) {
                File file = new File(url.toURI());
                result = new DefaultLogo(file);
            }
        }
        catch (Exception exception) {
            log.error("Failed to retrieve default logo: {}", (Object)exception.getMessage());
        }
        return result;
    }

    private static class DefaultLogo
    implements Logo {
        private final File file;

        public DefaultLogo(File file) {
            this.file = file;
        }

        @Override
        public InputStream getContent() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public String getMimeType() {
            return LogoServlet.DEFAULT_MIME_TYPE;
        }

        @Override
        public long getLastModified() {
            long result = -1L;
            try {
                result = this.file.lastModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        @Override
        public int getSize() {
            int length = 0;
            try {
                length = (int)this.file.length();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return length;
        }
    }

    private static class PracticeLogo
    implements Logo {
        private final ImageService.Image image;

        public PracticeLogo(ImageService.Image image) {
            this.image = image;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.image.getInputStream();
        }

        @Override
        public String getMimeType() {
            return this.image.getMimeType();
        }

        @Override
        public long getLastModified() {
            Date modified = this.image.getModified();
            return modified != null ? modified.getTime() : 0L;
        }

        @Override
        public int getSize() {
            return (int)this.image.getSize();
        }
    }

    private static interface Logo {
        public InputStream getContent() throws IOException;

        public String getMimeType();

        public long getLastModified();

        public int getSize();
    }
}

