/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.service;

import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.message.OutboundMessageBuilder;
import org.openvpms.sms.service.SMSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSMSService {
    private final SMSService smsService;
    private final ArchetypeService service;
    private final Contacts contacts;
    private static final Logger log = LoggerFactory.getLogger(SimpleSMSService.class);

    public SimpleSMSService(SMSService smsService, ArchetypeService service) {
        this.smsService = smsService;
        this.service = service;
        this.contacts = new Contacts(service);
    }

    public boolean isEnabled() {
        return this.smsService.isEnabled();
    }

    public int getParts(String message) {
        return this.smsService.getParts(message);
    }

    public int getMaxParts() {
        return this.smsService.getMaxParts();
    }

    public void send(String message, Contact contact, Party recipient, String subject, String reason, Party location) {
        this.send(message, contact, recipient, null, subject, reason, location);
    }

    public void send(String message, Contact contact, Party recipient, Party patient, String subject, String reason, Party location) {
        this.send(message, contact, recipient, patient, subject, reason, location, null);
    }

    public void send(String message, Contact contact, Party recipient, Party patient, String subject, String reason, Party location, Act source) {
        String phone = this.contacts.getPhone(contact);
        this.send(phone, message, recipient, patient, contact, subject, reason, location, source);
    }

    public void send(String phone, String message, Party recipient, Party patient, Contact contact, String subject, String reason, Party location) {
        this.send(phone, message, recipient, patient, contact, subject, reason, location, null);
    }

    public void send(String phone, String message, Party recipient, Party patient, Contact contact, String subject, String reason, Party location, Act source) {
        if (log.isDebugEnabled()) {
            String p = recipient != null ? recipient.getName() + " (" + recipient.getId() + ")" : null;
            String c = contact != null ? contact.getDescription() + " (" + contact.getId() + ")" : null;
            String l = location != null ? location.getName() + " (" + location.getId() + ")" : null;
            log.debug("SMS: phone={}, message='{}', party={}, contact={}, subject={}, reason={}, location={}", new Object[]{phone, message, p, c, subject, reason, l});
        }
        if (TypeHelper.isA((IMObject)recipient, (String)"party.customerperson")) {
            this.sendCustomerSMS(phone, message, recipient, patient, subject, reason, null, location, source);
        } else {
            this.sendGeneralSMS(phone, message, recipient, location, source);
        }
    }

    public void send(String phone, String message, Party customer, Party patient, Contact contact, String subject, String reason, String note, Party location) {
        if (log.isDebugEnabled()) {
            String p = patient != null ? patient.getName() + " (" + patient.getId() + ")" : null;
            String c = contact != null ? contact.getDescription() + " (" + contact.getId() + ")" : null;
            String l = location != null ? location.getName() + " (" + location.getId() + ")" : null;
            log.debug("SMS: phone={}, message='{}', customer={}, patient={}, contact={}, subject={}, reason={}, location={}", new Object[]{phone, message, customer.getName() + "(" + customer.getId() + ")", p, c, subject, reason, l});
        }
        this.sendCustomerSMS(phone, message, customer, patient, subject, reason, note, location, null);
    }

    protected void send(String phone, String message, Party location) {
        OutboundMessage sms = ((OutboundMessageBuilder)((OutboundMessageBuilder)((OutboundMessageBuilder)this.smsService.getOutboundMessageBuilder().phone(phone)).message(message)).location(location)).build();
        this.smsService.send(sms);
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    private void sendGeneralSMS(String phone, String message, Party recipient, Party location, Act source) {
        OutboundMessage sms = ((OutboundMessageBuilder)((OutboundMessageBuilder)((OutboundMessageBuilder)this.smsService.getOutboundMessageBuilder().phone(phone)).message(message)).recipient(recipient).location(location)).source(source).build();
        this.smsService.send(sms);
    }

    private void sendCustomerSMS(String phone, String message, Party customer, Party patient, String subject, String reason, String note, Party location, Act source) {
        OutboundMessage sms = ((OutboundMessageBuilder)((OutboundMessageBuilder)((OutboundMessageBuilder)this.smsService.getOutboundMessageBuilder().phone(phone)).message(message)).recipient(customer).patient(patient).subject(subject).reason(reason).note(note).location(location)).source(source).build();
        this.smsService.send(sms);
    }
}

