/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.service;

import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessagePreparator;

public abstract class MailService
implements JavaMailSender {
    private final MailPasswordResolver passwordResolver;
    private JavaMailSenderImpl sender;
    private MailServer settings;
    private boolean debug = false;
    private boolean debugAuth = false;
    private long connectionTimout = 0L;
    private static final String SMTP_PREFIX = "mail.smtp.";
    private static final String SMTPS_PREFIX = "mail.smtps.";
    private static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String MAIL_SMTP_AUTH_MECHANISMS = "mail.smtp.auth.mechanisms";
    private static final String CONNECTION_TIMEOUT = "connectiontimeout";
    private static final String READ_TIMEOUT = "timeout";
    private static final String WRITE_TIMEOUT = "writetimeout";
    private static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    private static final String MAIL_DEBUG = "mail.debug";
    private static final String MAIL_DEBUG_AUTH = "mail.debug.auth";

    public MailService(MailPasswordResolver passwordResolver) {
        this.passwordResolver = passwordResolver;
    }

    public MimeMessage createMimeMessage() {
        return this.getSender().createMimeMessage();
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        return this.getSender().createMimeMessage(contentStream);
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.getSender().send(mimeMessage);
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        this.getSender().send(mimeMessages);
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.getSender().send(mimeMessagePreparator);
    }

    public void send(MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        this.getSender().send(mimeMessagePreparators);
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.getSender().send(simpleMessage);
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        this.getSender().send(simpleMessages);
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimout = this.toMillis(timeout);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDebugAuth(boolean debug) {
        this.debugAuth = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMailSender getSender() {
        MailServer current;
        JavaMailSenderImpl result;
        MailService mailService = this;
        synchronized (mailService) {
            result = this.sender;
            current = this.settings;
        }
        MailServer newSettings = this.getMailServer();
        if (newSettings != null) {
            boolean create = false;
            String password = null;
            if (!Objects.equals(newSettings, current)) {
                create = true;
                password = this.passwordResolver.getPassword(newSettings);
            } else if (result != null && newSettings.getAuthenticationMethod() == MailServer.AuthenticationMethod.OAUTH2 && !StringUtils.equals((CharSequence)(password = this.passwordResolver.getPassword(newSettings)), (CharSequence)result.getPassword())) {
                create = true;
            }
            if (create) {
                result = this.setSender(this.createMailSender(newSettings, password), newSettings);
            }
        }
        if (result == null) {
            result = this.setSender(this.createMailSender(), newSettings);
        }
        return result;
    }

    protected JavaMailSenderImpl createMailSender(MailServer settings, String password) {
        long connect;
        boolean smtps;
        JavaMailSenderImpl result = this.createMailSender();
        Properties properties = result.getJavaMailProperties();
        result.setHost(settings.getHost());
        result.setPort(settings.getPort());
        String username = settings.getUsername();
        result.setUsername(username);
        result.setPassword(password);
        boolean bl = smtps = settings.getSecurity() == MailServer.Security.SSL_TLS;
        if (smtps) {
            result.setProtocol("smtps");
        } else if (settings.getSecurity() == MailServer.Security.STARTTLS) {
            properties.setProperty(MAIL_SMTP_AUTH, Boolean.toString(!StringUtils.isEmpty((CharSequence)username)));
            properties.setProperty(MAIL_SMTP_STARTTLS_ENABLE, Boolean.TRUE.toString());
        }
        if (settings.getAuthenticationMethod() == MailServer.AuthenticationMethod.OAUTH2) {
            properties.setProperty(MAIL_SMTP_AUTH_MECHANISMS, "XOAUTH2");
        }
        properties.setProperty(MAIL_DEBUG, Boolean.toString(this.debug));
        properties.setProperty(MAIL_DEBUG_AUTH, Boolean.toString(this.debugAuth));
        long timeout = this.toMillis(settings.getTimeout());
        long l = connect = this.connectionTimout > 0L ? this.connectionTimout : timeout;
        if (connect > 0L) {
            properties.setProperty(this.getProperty(CONNECTION_TIMEOUT, smtps), Long.toString(connect));
        }
        if (timeout > 0L) {
            String value = Long.toString(timeout);
            properties.setProperty(this.getProperty(READ_TIMEOUT, smtps), value);
            properties.setProperty(this.getProperty(WRITE_TIMEOUT, smtps), value);
        }
        return result;
    }

    protected JavaMailSenderImpl createMailSender() {
        JavaMailSenderImpl result = new JavaMailSenderImpl();
        result.setDefaultEncoding("UTF-8");
        return result;
    }

    protected abstract MailServer getMailServer();

    private long toMillis(int seconds) {
        return (long)seconds * 1000L;
    }

    private synchronized JavaMailSenderImpl setSender(JavaMailSenderImpl sender, MailServer settings) {
        this.sender = sender;
        this.settings = settings;
        return sender;
    }

    private String getProperty(String name, boolean smtps) {
        return smtps ? SMTPS_PREFIX + name : SMTP_PREFIX + name;
    }
}

