/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.util.ErrorHelper;

public class ModifiableListeners {
    private List<ModifiableListener> listeners;

    public void addListener(ModifiableListener listener) {
        this.addListener(listener, this.listeners != null ? this.listeners.size() : 0);
    }

    public void addListener(ModifiableListener listener, int index) {
        int existing;
        if (this.listeners == null) {
            this.listeners = new ArrayList<ModifiableListener>();
        }
        if ((existing = this.listeners.indexOf(listener)) != -1) {
            this.listeners.remove(listener);
            if (index > existing) {
                --index;
            }
        }
        this.listeners.add(index, listener);
    }

    public void removeListener(ModifiableListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyListeners(Modifiable modifiable) {
        try {
            if (this.listeners != null) {
                ModifiableListener[] list;
                for (ModifiableListener listener : list = this.listeners.toArray(new ModifiableListener[0])) {
                    listener.modified(modifiable);
                }
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show(exception);
        }
    }

    public void removeAll() {
        this.listeners.clear();
    }
}

