/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.archetype.rules.doc.LongTextReader;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class DocumentBackedTextProperty
extends DelegatingProperty {
    private final IMObject object;
    private final String relationshipNode;
    private MutableObject<String> cached;

    public DocumentBackedTextProperty(DocumentAct object, Property property) {
        this((IMObject)object, property, null);
    }

    public DocumentBackedTextProperty(IMObject object, Property property, String relationshipNode) {
        super(property);
        this.object = object;
        this.relationshipNode = relationshipNode;
    }

    public DocumentBackedTextProperty(IMObject object, String node, String relationshipNode) {
        super(DocumentBackedTextProperty.getProperty(object, node));
        this.object = object;
        this.relationshipNode = relationshipNode;
    }

    @Override
    public boolean setValue(Object value) {
        return false;
    }

    @Override
    public Object getValue() {
        Object value = super.getValue();
        if (value == null) {
            if (this.cached == null) {
                this.cached = new MutableObject((Object)this.loadText());
            }
            value = this.cached.getValue();
        }
        return value;
    }

    private String loadText() {
        LongTextReader reader = new LongTextReader((ArchetypeService)ServiceHelper.getArchetypeService());
        String result = null;
        result = this.relationshipNode != null ? reader.getText(this.object, this.getName(), this.relationshipNode) : reader.getText((DocumentAct)this.object, this.getName());
        return result;
    }

    private String getText(DocumentAct act) {
        Document document = IMObjectHelper.getObject(act.getDocument(), Document.class);
        return document != null ? TextDocumentHandler.asString((Document)document) : null;
    }

    private static Property getProperty(IMObject object, String node) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean(object);
        return new IMObjectProperty(object, bean.getNode(node));
    }
}

