/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class AbstractEditor
extends AbstractModifiable
implements Editor {
    private ModifiableListeners listeners;
    private ErrorListener errorListener;
    private AlertListener alertListener;
    private boolean modified;
    private FocusGroup focusGroup;

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.getListeners().addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.getListeners().addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        if (this.listeners != null) {
            this.listeners.removeListener(listener);
        }
    }

    @Override
    public FocusGroup getFocusGroup() {
        if (this.focusGroup == null) {
            this.focusGroup = new FocusGroup(this.getClass().getSimpleName());
        }
        return this.focusGroup;
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void setAlertListener(AlertListener listener) {
        this.alertListener = listener;
    }

    @Override
    public AlertListener getAlertListener() {
        return this.alertListener;
    }

    @Override
    public void dispose() {
        if (this.listeners != null) {
            this.listeners.removeAll();
            this.listeners = null;
        }
        this.focusGroup = null;
        this.errorListener = null;
        this.alertListener = null;
    }

    protected ModifiableListeners getListeners() {
        if (this.listeners == null) {
            this.listeners = new ModifiableListeners();
        }
        return this.listeners;
    }

    protected void setModified() {
        this.modified = true;
    }

    protected void notifyListeners() {
        if (this.listeners != null) {
            this.listeners.notifyListeners(this);
        }
    }
}

