/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.act.PrintedFlagUpdater;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.StaticDocumentTemplateLocator;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public abstract class BatchPrinter<T extends IMObject>
implements PrinterListener {
    private final Context context;
    private final HelpContext help;
    private Iterator<?> iterator;
    private T object;

    public BatchPrinter(List<T> objects, Context context, HelpContext help) {
        this(context, help);
        this.setObjects(objects);
    }

    public BatchPrinter(Context context, HelpContext help) {
        this.context = context;
        this.help = help;
    }

    public void setObjects(List<T> objects) {
        this.iterator = objects.iterator();
    }

    public void setObjectTemplates(List<ObjectTemplate<T>> objects) {
        this.iterator = objects.iterator();
    }

    public void print() {
        if (this.iterator != null && this.iterator.hasNext()) {
            Object next = this.iterator.next();
            try {
                DocumentTemplateLocator locator;
                if (next instanceof ObjectTemplate) {
                    ObjectTemplate entry = (ObjectTemplate)next;
                    this.object = (IMObject)entry.getObject();
                    locator = new StaticDocumentTemplateLocator(entry.getTemplate());
                } else {
                    this.object = (IMObject)next;
                    locator = this.createDocumentTemplateLocator(this.object, this.context);
                }
                IMPrinterFactory factory = ServiceHelper.getBean(IMPrinterFactory.class);
                IMPrinter<T> printer = factory.create(this.object, locator, this.context);
                InteractiveIMPrinter<T> iPrinter = this.createInteractivePrinter(printer);
                iPrinter.print();
            }
            catch (OpenVPMSException exception) {
                this.failed(exception);
            }
        } else {
            this.completed();
        }
    }

    @Override
    public void printed(DocumentPrinter printer) {
        if (this.object instanceof Act) {
            PrintedFlagUpdater updater = new PrintedFlagUpdater();
            updater.setPrinted((Act)this.object);
        }
        this.print();
    }

    @Override
    public void cancelled() {
        this.completed();
    }

    @Override
    public void skipped() {
        this.print();
    }

    protected DocumentTemplateLocator createDocumentTemplateLocator(T object, Context context) {
        return new ContextDocumentTemplateLocator((IMObject)object, context);
    }

    protected InteractiveIMPrinter<T> createInteractivePrinter(IMPrinter<T> printer) {
        InteractiveIMPrinter<T> result = new InteractiveIMPrinter<T>(printer, true, this.context, this.help);
        result.setListener(this);
        return result;
    }

    protected void completed() {
    }

    protected Context getContext() {
        return this.context;
    }

    public static class ObjectTemplate<T> {
        private final T object;
        private final DocumentTemplate template;

        public ObjectTemplate(T object, DocumentTemplate template) {
            this.object = object;
            this.template = template;
        }

        public T getObject() {
            return this.object;
        }

        public DocumentTemplate getTemplate() {
            return this.template;
        }
    }
}

