/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.component.im.table.IMObjectTable;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class BatchPrintDialog<T extends IMObject>
extends PopupDialog {
    private final String message;
    private final IMTable<T> table;

    public BatchPrintDialog(String title, List<T> objects, HelpContext help) {
        this(title, null, OK_CANCEL, objects, help);
    }

    public BatchPrintDialog(String title, String message, String[] buttons, List<T> objects, HelpContext help) {
        super(title, buttons, help);
        this.message = message;
        this.setModal(true);
        this.table = new IMObjectTable(new PrintTableModel());
        this.table.setObjects(objects);
    }

    public BatchPrintDialog(String title, String message, String[] buttons, Map<T, Boolean> objects, HelpContext help) {
        super(title, buttons, help);
        this.message = message;
        this.setModal(true);
        this.table = new IMObjectTable(new PrintTableModel(new ArrayList<Boolean>(objects.values())));
        this.table.setObjects(new ArrayList<T>(objects.keySet()));
    }

    public List<T> getAvailable() {
        return this.table.getObjects();
    }

    public List<T> getSelected() {
        PrintTableModel model = (PrintTableModel)this.table.getModel();
        return model.getSelected();
    }

    protected void onOK() {
        if (!this.getSelected().isEmpty()) {
            super.onOK();
        }
    }

    protected void doLayout() {
        Column column = ColumnFactory.create((String)"WideCellSpacing");
        if (this.message != null) {
            Label label = LabelFactory.create((boolean)true, (boolean)true);
            label.setStyleName("bold");
            label.setText(this.message);
            column.add((Component)label);
        }
        column.add(this.table);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    private class PrintTableModel
    extends BaseIMObjectTableModel<T> {
        private final int PRINT_INDEX = 6;
        private final List<Boolean> selections;
        private List<CheckBox> print;
        private static final String DOCUMENT_TEMPLATE = "documentTemplate";

        public PrintTableModel() {
            this(null);
        }

        public PrintTableModel(List<Boolean> selections) {
            super(null);
            this.PRINT_INDEX = 6;
            this.print = new ArrayList<CheckBox>();
            this.setTableColumnModel(this.createTableColumnModel(true));
            this.selections = selections;
        }

        public List<T> getSelected() {
            ArrayList result = new ArrayList();
            for (int i = 0; i < this.print.size(); ++i) {
                CheckBox check = this.print.get(i);
                if (!check.isSelected()) continue;
                result.add(this.getObject(i));
            }
            return result;
        }

        @Override
        public void setObjects(List<T> objects) {
            super.setObjects(objects);
            this.print = new ArrayList<CheckBox>();
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                boolean selected = this.selections != null && i < this.selections.size() ? this.selections.get(i) : true;
                this.print.add((CheckBox)CheckBoxFactory.create((boolean)selected));
            }
        }

        @Override
        protected Object getValue(T object, TableColumn column, int row) {
            Object result;
            if (column.getModelIndex() == 6) {
                result = this.print.get(row);
            } else if (column.getModelIndex() == 4) {
                String description = object.getDescription();
                if (StringUtils.isEmpty((CharSequence)description) && object instanceof DocumentAct) {
                    Entity template;
                    IMObjectBean bean = ServiceHelper.getArchetypeService().getBean(object);
                    Entity entity = template = bean.hasNode(DOCUMENT_TEMPLATE) ? (Entity)bean.getTarget(DOCUMENT_TEMPLATE, Entity.class) : null;
                    if (template != null) {
                        description = template.getName();
                    }
                }
                result = description;
            } else {
                result = super.getValue(object, column, row);
            }
            return result;
        }

        @Override
        protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype) {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            TableColumn column = PrintTableModel.createTableColumn(6, "batchprintdialog.print");
            model.addColumn(column);
            return super.createTableColumnModel(showId, showArchetype, (TableColumnModel)model);
        }
    }
}

