/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractArchetypeQuery;
import org.openvpms.web.component.im.query.DefaultResultSet;
import org.openvpms.web.component.im.query.ResultSet;

class EmailQuery
extends AbstractArchetypeQuery<Contact> {
    private static final String[] PARTY_SHORT_NAMES = new String[]{"party.customerperson", "party.organisationPractice", "party.organisationLocation", "party.supplierorganisation", "party.supplierperson", "party.supplierManufacturer", "party.supplierVeterinarian", "party.supplierVeterinaryPractice", "security.user"};
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{Constraints.sort((String)"party", (String)"name"), Constraints.sort((String)"party", (String)"id")};

    public EmailQuery() {
        super(PARTY_SHORT_NAMES, false, IMObject.class);
        this.setAuto(true);
        this.setDefaultSortConstraint(DEFAULT_SORT);
    }

    @Override
    protected ResultSet<Contact> createResultSet(SortConstraint[] sort) {
        if (sort == null) {
            sort = this.getDefaultSortConstraint();
        }
        ShortNameConstraint contact = Constraints.shortName((String)"contact", (String)"contact.email");
        ShortNameConstraint parties = Constraints.shortName((String)"party", (String[])this.getArchetypeConstraint().getShortNames());
        parties.add((IConstraint)Constraints.join((String)"contacts", (String)"c").add((IConstraint)Constraints.idEq((String)"contact", (String)"c")));
        contact.add((IConstraint)parties);
        parties.setState(this.getArchetypeConstraint().getState());
        return new DefaultResultSet<Contact>(contact, this.getValue(), null, sort, this.getMaxResults(), this.isDistinct()){

            @Override
            protected List<IConstraint> createValueConstraints(String value, List<String> nodes) {
                ArrayList<IConstraint> constraints = new ArrayList<IConstraint>();
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    constraints.add((IConstraint)Constraints.eq((String)"party.name", (Object)value));
                }
                return constraints;
            }
        };
    }
}

