/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.TemporaryDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.resource.Content;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.doc.DocumentGenerator;
import org.openvpms.web.component.im.doc.DocumentGeneratorFactory;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.ActAttachment;
import org.openvpms.web.component.mail.ContentAttachment;
import org.openvpms.web.component.mail.MailAttachment;
import org.openvpms.web.component.mail.MailException;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class AttachmentGenerator {
    private final ArchetypeService service;
    private final DocumentGeneratorFactory documentGeneratorFactory;
    private final IMPrinterFactory printerFactory;
    private final DocumentConverter converter;
    private final DocumentJobManager jobManager;
    private final Context context;
    private final HelpContext help;

    public AttachmentGenerator(ArchetypeService service, DocumentGeneratorFactory documentGeneratorFactory, IMPrinterFactory printerFactory, DocumentConverter converter, DocumentJobManager jobManager, Context context, HelpContext help) {
        this.service = service;
        this.documentGeneratorFactory = documentGeneratorFactory;
        this.printerFactory = printerFactory;
        this.converter = converter;
        this.jobManager = jobManager;
        this.context = context;
        this.help = help;
    }

    public void generate(MailAttachment attachment, Consumer<Result> listener) {
        if (attachment instanceof ActAttachment) {
            this.generate((Act)((ActAttachment)attachment).getContent(), listener);
        } else if (attachment instanceof ContentAttachment) {
            this.generate((Content)((ContentAttachment)attachment).getContent(), listener);
        } else {
            listener.accept(Result.error("Unsupported attachment type"));
        }
    }

    private void generate(Act act, Consumer<Result> listener) {
        try {
            if (act instanceof DocumentAct) {
                this.generateFromDocumentAct((DocumentAct)act, listener);
            } else {
                this.generateFromTemplate(act, listener);
            }
        }
        catch (Throwable exception) {
            listener.accept(Result.error(exception));
        }
    }

    private void generateFromDocumentAct(DocumentAct act, final Consumer<Result> listener) {
        org.openvpms.component.model.document.Document document = null;
        if (act.getDocument() != null) {
            document = (org.openvpms.component.model.document.Document)this.service.get(act.getDocument(), org.openvpms.component.model.document.Document.class);
        }
        if (document != null) {
            this.generateFromDocument(document, listener);
        } else if (act.isA("act.*DocumentLetter")) {
            String message = Messages.format((String)"document.attachment.nocontent", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service)});
            listener.accept(Result.error(message));
        } else {
            DocumentGenerator.AbstractListener l = new DocumentGenerator.AbstractListener(){

                @Override
                public void generated(org.openvpms.component.model.document.Document document) {
                    listener.accept(Result.create(document));
                }

                @Override
                public void error(Throwable cause) {
                    listener.accept(Result.error(cause));
                }
            };
            DocumentGenerator generator = this.documentGeneratorFactory.create(act, this.context, this.help, l);
            generator.setMimeType("application/pdf");
            generator.generate();
        }
    }

    private void generateFromDocument(org.openvpms.component.model.document.Document document, Consumer<Result> listener) {
        if (this.canConvertToPDF(document)) {
            Job<org.openvpms.component.model.document.Document> job = JobBuilder.newJob(document.getName(), this.context.getUser()).get(() -> this.converter.convert(document, "application/pdf", true)).completed(converted -> listener.accept(Result.create(converted))).failed(error -> listener.accept(Result.error(error))).build();
            this.jobManager.runInteractive(job, Messages.get((String)"document.convert.title"), Messages.get((String)"document.convert.cancel"));
        } else {
            listener.accept(Result.create(document));
        }
    }

    private boolean canConvertToPDF(org.openvpms.component.model.document.Document document) {
        boolean result = false;
        String mimeType = document.getMimeType();
        if (!StringUtils.isEmpty((CharSequence)mimeType) && !"application/pdf".equals(mimeType)) {
            result = this.converter.canConvert(document, "application/pdf");
        }
        return result;
    }

    private void generateFromTemplate(Act act, Consumer<Result> listener) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator((IMObject)act, this.context);
        IMPrinter<Act> printer = this.printerFactory.create(act, locator, this.context);
        Job<org.openvpms.component.model.document.Document> job = JobBuilder.newJob(printer.getDisplayName(), this.context.getUser()).get(() -> printer.getDocument("application/pdf", true)).completed(converted -> listener.accept(Result.create(converted))).failed(error -> listener.accept(Result.error(error))).build();
        this.jobManager.runInteractive(job, Messages.get((String)"document.generateattachment.title"), Messages.get((String)"document.generateattachment.cancel"));
    }

    private void generate(Content content, Consumer<Result> listener) {
        try (CheckedCountingInputStream stream = new CheckedCountingInputStream(content);){
            TemporaryDocumentHandler handler = new TemporaryDocumentHandler((ArchetypeService)ServiceHelper.getArchetypeService());
            Document document = handler.create(content.getName(), (InputStream)((Object)stream), content.getMimeType(), -1);
            listener.accept(Result.create((org.openvpms.component.model.document.Document)document));
        }
        catch (Throwable exception) {
            listener.accept(Result.error(exception));
        }
    }

    private static class CheckedCountingInputStream
    extends CountingInputStream {
        private final Content content;

        public CheckedCountingInputStream(Content content) {
            super(content.getContent());
            this.content = content;
        }

        protected synchronized void afterRead(int n) {
            super.afterRead(n);
            if (this.getByteCount() > 15000000L) {
                throw new MailException(MailException.ErrorCode.AttachmentTooLarge, this.content.getName());
            }
        }
    }

    public static class Result {
        private final org.openvpms.component.model.document.Document document;
        private final String error;
        private final Throwable cause;

        private Result(org.openvpms.component.model.document.Document document, String error, Throwable cause) {
            this.document = document;
            this.error = error;
            this.cause = cause;
        }

        public org.openvpms.component.model.document.Document getDocument() {
            return this.document;
        }

        public String getError() {
            return this.error;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public static Result create(org.openvpms.component.model.document.Document document) {
            return new Result(document, null, null);
        }

        public static Result error(String error) {
            return new Result(null, error, null);
        }

        public static Result error(Throwable cause) {
            String error = ErrorFormatter.format(cause);
            return new Result(null, error, cause);
        }
    }
}

