/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.macro;

import java.util.HashMap;
import java.util.Map;
import org.openvpms.component.business.service.archetype.helper.AbstractPropertyResolver;
import org.openvpms.component.business.service.archetype.helper.IMObjectVariables;
import org.openvpms.component.business.service.archetype.helper.PropertyResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;

public class MacroVariables
extends IMObjectVariables {
    public static final String PRACTICE = "practice";
    public static final String LOCATION = "location";
    public static final String STOCK_LOCATION = "stockLocation";
    public static final String CUSTOMER = "customer";
    public static final String PATIENT = "patient";
    public static final String SUPPLIER = "supplier";
    public static final String PRODUCT = "product";
    public static final String USER = "user";
    public static final String CLINICIAN = "clinician";
    public static final String TILL = "till";
    public static final String DEPOSIT_ACCOUNT = "depositAccount";
    public static final String VISIT = "visit";
    public static final String INVOICE = "invoice";
    public static final String APPOINTMENT = "appointment";
    public static final String TASK = "task";
    private final Context context;
    public static final Map<String, String> MAPPINGS = new HashMap<String, String>();

    public MacroVariables(Context context, ArchetypeService service, LookupService lookups) {
        super(service, lookups);
        this.context = context;
    }

    private IMObject getContextObject(String name, String shortName) {
        Object result = USER.equals(name) ? this.context.getUser() : (CLINICIAN.equals(name) ? this.context.getClinician() : this.context.getObject(shortName));
        return result;
    }

    protected PropertyResolver createResolver(final PropertySet variables, ArchetypeService service, LookupService lookups) {
        return new AbstractPropertyResolver(service, lookups){

            protected Object get(String name) {
                String mapping = MAPPINGS.get(name);
                if (mapping == null) {
                    return variables.get(name);
                }
                IMObject object = MacroVariables.this.getContextObject(name, mapping);
                if (object == null) {
                    throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidObject, new Object[]{name});
                }
                return object;
            }

            protected boolean exists(String name) {
                String mapping = MAPPINGS.get(name);
                return mapping == null ? variables.exists(name) : MacroVariables.this.getContextObject(name, mapping) != null;
            }

            public Object getObject(String name) {
                return MacroVariables.this.getValue(this.resolve(name));
            }
        };
    }

    static {
        MAPPINGS.put(PRACTICE, "party.organisationPractice");
        MAPPINGS.put(LOCATION, "party.organisationLocation");
        MAPPINGS.put(STOCK_LOCATION, "party.organisationStockLocation");
        MAPPINGS.put(CUSTOMER, "party.customer*");
        MAPPINGS.put(PATIENT, "party.patient*");
        MAPPINGS.put(SUPPLIER, "party.supplier*");
        MAPPINGS.put(CLINICIAN, "security.user");
        MAPPINGS.put(PRODUCT, "product.*");
        MAPPINGS.put(TILL, "party.organisationTill");
        MAPPINGS.put(DEPOSIT_ACCOUNT, "party.organisationDeposit");
        MAPPINGS.put(USER, "security.user");
        MAPPINGS.put(VISIT, "act.patientClinicalEvent");
        MAPPINGS.put(INVOICE, "act.customerAccountChargesInvoice");
        MAPPINGS.put(APPOINTMENT, "act.customerAppointment");
        MAPPINGS.put(TASK, "act.customerTask");
    }
}

