/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.macro;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.macro.MacroQuery;
import org.openvpms.web.component.macro.MacroTableModel;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.focus.FocusCommand;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.RichTextArea;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.resource.i18n.Messages;

public class MacroDialog
extends PopupDialog {
    private final FocusCommand focus = new FocusCommand();

    public MacroDialog(Context context, HelpContext help) {
        super(Messages.get((String)"macros.title"), "MacroDialog", CLOSE, help);
        MacroQuery query = new MacroQuery();
        QueryFactory.initialise(query);
        query.setShowInactive(false);
        DefaultLayoutContext layout = new DefaultLayoutContext(context, help);
        MacroTableModel model = new MacroTableModel(false, false, layout);
        Browser<Lookup> browser = BrowserFactory.create(query, query.getDefaultSortConstraint(), model, (LayoutContext)layout);
        browser.addBrowserListener(new BrowserListener<Lookup>(){

            @Override
            public void selected(Lookup object) {
                MacroDialog.this.onSelected(object);
            }

            @Override
            public void browsed(Lookup object) {
            }

            @Override
            public void query() {
            }
        });
        this.getLayout().add(browser.getComponent());
        this.getFocusGroup().add(0, browser.getFocusGroup());
        this.getButtons().addKeyListener(27, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                MacroDialog.this.onClose();
            }
        });
        query.setFocus();
        this.setModal(true);
    }

    public void userClose() {
        this.focus.restore();
        super.userClose();
    }

    private void onSelected(Lookup macro) {
        TextComponent text;
        Component component = this.focus.getComponent();
        if (component != null && component instanceof TextComponent && (text = (TextComponent)component).isEnabled() && text.isVisible()) {
            if (text instanceof RichTextArea) {
                this.expandMacro((RichTextArea)text, macro);
            } else {
                this.insertMacro(text, macro);
            }
        }
        this.onClose();
    }

    private void expandMacro(RichTextArea text, Lookup macro) {
        text.insertMacro(macro.getCode());
    }

    private void insertMacro(TextComponent text, Lookup macro) {
        int position = text.getCursorPosition();
        String value = text.getText();
        String code = macro.getCode();
        value = value != null ? (position < value.length() ? value.substring(0, position) + code + value.substring(position) : value + code) : code;
        text.setText(value);
        text.setCursorPosition(text.getCursorPosition() + code.length());
    }
}

