/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.ReadOnlyProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;

public abstract class SingleIMObjectCollectionViewer
implements IMObjectCollectionViewer {
    private final CollectionProperty property;
    private final IMObject parent;
    private final LayoutContext context;
    private IMObject selected;
    private Component component;

    public SingleIMObjectCollectionViewer(CollectionProperty property, IMObject parent, LayoutContext context) {
        this.property = property;
        this.parent = parent;
        this.context = context;
    }

    @Override
    public CollectionProperty getProperty() {
        return this.property;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            List<?> values = this.property.getValues();
            if (!values.isEmpty()) {
                this.selected = (IMObject)values.get(0);
                this.component = this.createComponent(this.selected, this.parent, this.context);
            } else {
                this.component = SingleIMObjectCollectionViewer.createEmptyCollectionViewer();
            }
        }
        return this.component;
    }

    @Override
    public IMObject getSelected() {
        return this.selected;
    }

    public static Component createEmptyCollectionViewer() {
        TextField component = TextComponentFactory.create((int)20);
        component.setText(Messages.get((String)"imobject.none"));
        component.setEnabled(false);
        return component;
    }

    protected abstract Component createComponent(IMObject var1, IMObject var2, LayoutContext var3);

    protected Component createComponent(IMObject object, String node) {
        NodeDescriptor descriptor = this.context.getArchetypeDescriptor(object).getNodeDescriptor(node);
        if (descriptor != null) {
            CollectionProperty property = new IMObjectProperty(object, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
            if (this.context.isEdit() && !property.isReadOnly()) {
                property = new ReadOnlyProperty(property);
            }
            return this.context.getComponentFactory().create((Property)property, object).getComponent();
        }
        return LabelFactory.create();
    }
}

