/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.AbstractIMObjectView;
import org.openvpms.web.component.im.view.AbstractReadOnlyComponentFactory;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.im.view.layout.ViewLayoutStrategyFactory;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.system.ServiceHelper;

public class IMObjectViewer
extends AbstractIMObjectView {
    private final LayoutContext context;
    private String title;

    public IMObjectViewer(IMObject object, LayoutContext context) {
        this(object, null, context);
    }

    public IMObjectViewer(IMObject object, IMObject parent, LayoutContext context) {
        this(object, parent, ServiceHelper.getBean(ViewLayoutStrategyFactory.class).create(object), context);
    }

    public IMObjectViewer(IMObject object, IMObject parent, IMObjectLayoutStrategy layout, LayoutContext context) {
        super(object, new PropertySetBuilder(object, context).build(), parent, layout);
        if (context.getComponentFactory() instanceof AbstractReadOnlyComponentFactory) {
            this.context = context;
        } else {
            this.context = new DefaultLayoutContext(context);
            this.context.setLayoutDepth(context.getLayoutDepth());
            ReadOnlyComponentFactory factory = new ReadOnlyComponentFactory(this.context);
            this.context.setComponentFactory(factory);
        }
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = DescriptorHelper.getDisplayName((IMObject)this.getObject(), (ArchetypeService)ServiceHelper.getArchetypeService());
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContextSwitchListener(ContextSwitchListener listener) {
        this.context.setContextSwitchListener(listener);
    }

    @Override
    protected LayoutContext getLayoutContext() {
        return this.context;
    }
}

