/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import echopointng.LabelEx;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;

public class IMObjectReferenceViewer {
    private final Reference reference;
    private final String name;
    private final String tooltip;
    private final ActionListener linkListener;
    private final ContextSwitchListener listener;
    private final Context context;
    private String style;
    private int width = -1;

    public IMObjectReferenceViewer(Reference reference, boolean link, Context context) {
        this(reference, null, link, context);
    }

    public IMObjectReferenceViewer(Reference reference, ContextSwitchListener listener, Context context) {
        this(reference, null, listener, context);
    }

    public IMObjectReferenceViewer(Reference reference, String name, boolean link, Context context) {
        this(reference, name, link ? DefaultContextSwitchListener.INSTANCE : null, context);
    }

    public IMObjectReferenceViewer(Reference reference, String name, ContextSwitchListener listener, Context context) {
        this(reference, name, null, listener, context);
    }

    public IMObjectReferenceViewer(Reference reference, String name, String tooltip, ContextSwitchListener listener, Context context) {
        this.reference = reference;
        this.name = name;
        this.tooltip = tooltip;
        this.listener = listener;
        this.linkListener = listener != null ? new ActionListener(){

            public void onAction(ActionEvent event) {
                IMObjectReferenceViewer.this.onView();
            }
        } : null;
        this.context = context;
    }

    public IMObjectReferenceViewer(Reference reference, String name, ActionListener listener, Context context) {
        this(reference, name, null, listener, context);
    }

    public IMObjectReferenceViewer(Reference reference, String name, String tooltip, final ActionListener listener, Context context) {
        this.reference = reference;
        this.name = name;
        this.tooltip = tooltip;
        this.listener = null;
        this.linkListener = new ActionListener(){

            public void onAction(ActionEvent event) {
                event = new ActionEvent((Object)IMObjectReferenceViewer.this, event.getActionCommand());
                listener.actionPerformed(event);
            }
        };
        this.context = context;
    }

    public void setStyleName(String style) {
        this.style = style;
    }

    public Component getComponent() {
        Label result;
        String text = this.name;
        if (text == null) {
            text = IMObjectHelper.getName(this.reference);
            text = text != null ? Messages.format((String)"imobject.name", (Object[])new Object[]{text}) : Messages.get((String)"imobject.none");
        }
        if (text != null) {
            if (this.linkListener != null) {
                if (this.style == null) {
                    this.style = "hyperlink";
                }
                Button button = ButtonFactory.create(null, (String)this.style, (boolean)false);
                button.setText(text);
                button.addActionListener((nextapp.echo2.app.event.ActionListener)this.linkListener);
                button.setFocusTraversalParticipant(false);
                if (this.tooltip != null) {
                    button.setToolTipText(this.tooltip);
                }
                if (this.width != -1) {
                    button.setWidth(new Extent(this.width));
                    result = button;
                } else {
                    result = RowFactory.create((Component[])new Component[]{button});
                }
            } else {
                result = this.createLabel(text);
            }
        } else {
            result = this.createLabel(Messages.get((String)"imobject.none"));
        }
        return result;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    protected void onView() {
        IMObject object = IMObjectHelper.getObject(this.reference, this.context);
        if (object != null) {
            this.listener.switchTo(object);
        }
    }

    private Label createLabel(String text) {
        Label result;
        if (this.width > 0) {
            LabelEx label = new LabelEx();
            label.setWidth(new Extent(this.width));
            result = label;
        } else {
            result = new Label();
        }
        result.setStyleName(this.style != null ? this.style : "default");
        result.setText(text);
        if (this.tooltip != null) {
            result.setToolTipText(this.tooltip);
        }
        return result;
    }
}

