/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.AbstractIMObjectComponentFactory;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.im.view.IMObjectCollectionViewer;
import org.openvpms.web.component.im.view.IMObjectCollectionViewerFactory;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.SingleIMObjectCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.LabelFactory;

public abstract class AbstractReadOnlyComponentFactory
extends AbstractIMObjectComponentFactory {
    private final IMObjectLayoutStrategyFactory strategies;

    public AbstractReadOnlyComponentFactory(LayoutContext context, IMObjectLayoutStrategyFactory strategies, String style) {
        super(context, style);
        this.strategies = strategies;
    }

    @Override
    public Component create(Property property) {
        return this.create(property, (Hint)null);
    }

    @Override
    public Component create(Property property, Hint hint) {
        Component component = super.create(property, hint);
        if (component != null) {
            component.setEnabled(false);
            component.setFocusTraversalParticipant(false);
        }
        return component;
    }

    @Override
    public ComponentState create(Property property, IMObject context) {
        return this.create(property, context, null);
    }

    @Override
    public ComponentState create(Property property, IMObject context, Hint hint) {
        Component component = null;
        if (!property.isLookup()) {
            component = this.create(property, hint);
        }
        if (component == null) {
            if (property.isLookup()) {
                component = this.createLookup(property, context);
            } else if (property.isCollection()) {
                component = this.getCollectionViewer((CollectionProperty)property, context);
            } else if (property.isObjectReference()) {
                component = this.getObjectViewer(property, context);
            } else {
                Label label = LabelFactory.create();
                label.setText("No viewer for type " + property.getType());
                component = label;
            }
        }
        component.setFocusTraversalParticipant(false);
        return new ComponentState(component, property);
    }

    @Override
    public ComponentState create(IMObject object, IMObject context) {
        IMObjectLayoutStrategy strategy = this.strategies.create(object, context);
        LayoutContext layout = this.getLayoutContext();
        layout.setRendered(object);
        if (layout.getComponentFactory() != this) {
            int depth = layout.getLayoutDepth();
            layout = new DefaultLayoutContext(layout);
            layout.setLayoutDepth(depth);
            layout.setComponentFactory(this);
        }
        IMObjectViewer viewer = new IMObjectViewer(object, context, strategy, layout);
        return new ComponentState(viewer.getComponent(), viewer.getFocusGroup());
    }

    protected abstract Component createLookup(Property var1, IMObject var2);

    protected Component getObjectViewer(Property property, IMObject context) {
        String[] range;
        IMObjectReference ref = (IMObjectReference)property.getValue();
        boolean link = false;
        ContextSwitchListener listener = null;
        LayoutContext layout = this.getLayoutContext();
        if (!layout.isEdit()) {
            listener = layout.getContextSwitchListener();
            link = true;
        }
        if (TypeHelper.matches((String[])(range = property.getArchetypeRange()), (String)"document.*")) {
            return this.createDocumentViewer(context, (Reference)ref, link, layout);
        }
        return this.getObjectViewer((Reference)ref, listener, layout);
    }

    protected Component getObjectViewer(Reference reference, ContextSwitchListener listener, LayoutContext layout) {
        return new IMObjectReferenceViewer(reference, listener, layout.getContext()).getComponent();
    }

    protected Component createDocumentViewer(IMObject context, Reference reference, boolean link, LayoutContext layout) {
        return new DocumentViewer(reference, context, link, false, layout).getComponent();
    }

    protected Component getCollectionViewer(CollectionProperty property, IMObject parent) {
        Label result = null;
        if (property.getMaxCardinality() == 1) {
            List<?> values = property.getValues();
            if (values.isEmpty()) {
                result = this.getEmptyCollectionViewer();
            }
        } else if (property.getMinCardinality() == 0 && property.getMaxCardinality() == 0) {
            result = LabelFactory.create();
        }
        if (result == null) {
            IMObjectCollectionViewer viewer = IMObjectCollectionViewerFactory.create(property, parent, this.getLayoutContext());
            result = viewer.getComponent();
        }
        return result;
    }

    protected Component getEmptyCollectionViewer() {
        return SingleIMObjectCollectionViewer.createEmptyCollectionViewer();
    }
}

