/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.system.ServiceHelper;

public class UserHelper {
    private static final String USE_LOGGED_IN_CLINICIAN = "useLoggedInClinician";

    public static boolean isAdmin(User user) {
        if (user != null) {
            UserRules rules = ServiceHelper.getBean(UserRules.class);
            return rules.isAdministrator(user);
        }
        return false;
    }

    public static boolean isClinician(User user) {
        return user != null && ServiceHelper.getBean(UserRules.class).isClinician(user);
    }

    public static boolean useLoggedInClinician(Context context) {
        IMObjectBean bean;
        boolean result = false;
        User user = context.getUser();
        Party practice = context.getPractice();
        if (user != null && practice != null && (bean = ServiceHelper.getArchetypeService().getBean((IMObject)practice)).getBoolean(USE_LOGGED_IN_CLINICIAN) && UserHelper.isClinician(user)) {
            result = true;
        }
        return result;
    }

    public static User getClinician(Context context) {
        User result = null;
        User user = context.getUser();
        Party practice = context.getPractice();
        if (user != null && practice != null) {
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)practice);
            if (bean.getBoolean(USE_LOGGED_IN_CLINICIAN)) {
                if (UserHelper.isClinician(user)) {
                    result = user;
                }
            } else {
                result = context.getClinician();
            }
        }
        return result;
    }

    public static String getName(String loginName) {
        String result = null;
        if (loginName != null) {
            User user = ServiceHelper.getBean(UserRules.class).getUser(loginName);
            result = user != null ? user.getName() : loginName;
        }
        return result;
    }
}

