/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.ArchetypeQueryHelper;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.util.StringUtilities;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectHelper {
    private static final Logger log = LoggerFactory.getLogger(IMObjectHelper.class);

    public static org.openvpms.component.model.object.IMObject getObject(Reference reference) {
        return IMObjectHelper.getObject(reference, (Context)null);
    }

    public static <T extends org.openvpms.component.model.object.IMObject> T getObject(Reference reference, Class<T> type) {
        org.openvpms.component.model.object.IMObject object = IMObjectHelper.getObject(reference);
        return (T)(object != null ? (org.openvpms.component.model.object.IMObject)type.cast(object) : null);
    }

    public static org.openvpms.component.model.object.IMObject getObject(Reference reference, Context context) {
        org.openvpms.component.model.object.IMObject result = null;
        if (reference != null) {
            if (context != null) {
                result = context.getObject(reference);
            }
            if (result == null || result.getVersion() < 0L) {
                try {
                    IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
                    result = service.get(reference);
                }
                catch (OpenVPMSException error) {
                    log.error(error.getMessage(), (Throwable)error);
                }
            }
        }
        return result;
    }

    public static IMObjectBean getBean(org.openvpms.component.model.object.IMObject object) {
        return ServiceHelper.getArchetypeService().getBean(object);
    }

    public static String getName(Reference reference) {
        return reference != null ? IMObjectHelper.getName(reference, (IArchetypeService)ServiceHelper.getArchetypeService()) : null;
    }

    public static String getName(Reference reference, IArchetypeService service) {
        String result = null;
        try {
            result = ArchetypeQueryHelper.getName((Reference)reference, (IArchetypeService)service);
        }
        catch (OpenVPMSException error) {
            log.error(error.getMessage(), (Throwable)error);
        }
        return result;
    }

    public static boolean isActive(Reference reference) {
        if (reference != null) {
            try {
                ObjectRefConstraint constraint = new ObjectRefConstraint("o", reference);
                ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)constraint);
                query.add((IConstraint)new NodeSelectConstraint("o.active"));
                query.setMaxResults(1);
                ObjectSetQueryIterator iter = new ObjectSetQueryIterator((IArchetypeQuery)query);
                if (iter.hasNext()) {
                    ObjectSet set = (ObjectSet)iter.next();
                    return set.getBoolean("o.active");
                }
            }
            catch (OpenVPMSException error) {
                log.error(error.getMessage(), (Throwable)error);
            }
        }
        return false;
    }

    public static org.openvpms.component.model.object.IMObject getObject(Reference reference, String[] shortNames, Context context) {
        org.openvpms.component.model.object.IMObject result = reference == null ? IMObjectHelper.match(shortNames, context) : IMObjectHelper.getObject(reference, context);
        return result;
    }

    public static <T extends org.openvpms.component.model.object.IMObject> T reload(T object) {
        return IMObjectHelper.reload(object, false);
    }

    public static <T extends org.openvpms.component.model.object.IMObject> T reload(T object, boolean failOnError) {
        Object result = object;
        if (object != null && !object.isNew()) {
            IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
            try {
                result = service.get(object.getObjectReference());
            }
            catch (OpenVPMSException error) {
                log.error(error.getMessage(), (Throwable)error);
            }
            if (result == null && failOnError) {
                throw new IllegalStateException(Messages.format((String)"imobject.noexist", (Object[])new Object[]{DescriptorHelper.getDisplayName(object, (ArchetypeService)service)}));
            }
        }
        return result;
    }

    public static Object getValue(org.openvpms.component.model.object.IMObject object, String node) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean(object);
        return bean.hasNode(node) ? bean.getValue(node) : null;
    }

    public static <T extends org.openvpms.component.model.object.IMObject> T getObject(String shortName, Collection<T> objects) {
        org.openvpms.component.model.object.IMObject result = null;
        for (org.openvpms.component.model.object.IMObject object : objects) {
            if (!TypeHelper.isA((org.openvpms.component.model.object.IMObject)object, (String)shortName)) continue;
            result = object;
            break;
        }
        return (T)result;
    }

    public static <T extends org.openvpms.component.model.object.IMObject> T getObject(Reference reference, Collection<T> objects) {
        if (reference != null) {
            for (org.openvpms.component.model.object.IMObject object : objects) {
                if (object == null || !Objects.equals(object.getObjectReference(), reference)) continue;
                return (T)object;
            }
        }
        return null;
    }

    public static <T extends org.openvpms.component.model.object.IMObject> List<T> findByName(String name, Collection<T> objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (StringUtils.isEmpty((CharSequence)name)) {
            result.addAll(objects);
        } else {
            try {
                String regex = StringUtilities.toRegEx((String)name.toLowerCase());
                for (org.openvpms.component.model.object.IMObject object : objects) {
                    String value = object.getName();
                    if (value == null || !value.toLowerCase().matches(regex)) continue;
                    result.add(object);
                }
            }
            catch (PatternSyntaxException exception) {
                log.warn(exception.getMessage(), (Throwable)exception);
            }
        }
        return result;
    }

    public static Class<?> getType(String[] shortNames) {
        Class<Object> result = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet classes = new HashSet();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (String shortName : shortNames) {
            ArchetypeDescriptor archetype = service.getArchetypeDescriptor(shortName);
            try {
                Class<?> clazz = loader.loadClass(archetype.getClassName());
                classes.add(clazz);
            }
            catch (ClassNotFoundException exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        for (Class clazz : classes) {
            if (result == null) {
                result = clazz;
            } else {
                while (!result.isAssignableFrom(clazz)) {
                    result = result.getSuperclass();
                }
            }
            if (result != Object.class) continue;
            result = org.openvpms.component.model.object.IMObject.class;
            break;
        }
        return result == null ? org.openvpms.component.model.object.IMObject.class : result;
    }

    public static boolean isSame(org.openvpms.component.model.object.IMObject object, org.openvpms.component.model.object.IMObject other) {
        if (object != null && other != null) {
            return object.getObjectReference().equals((Object)other.getObjectReference()) && object.getVersion() == other.getVersion();
        }
        return false;
    }

    public static boolean hasNewerVersion(org.openvpms.component.model.object.IMObject object) {
        boolean result = false;
        if (object != null) {
            try {
                IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
                IMObject o = service.get(object.getObjectReference());
                if (o != null && o.getVersion() > object.getVersion()) {
                    result = true;
                }
            }
            catch (OpenVPMSException exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return result;
    }

    public static boolean hasActiveInstance(String archetype) {
        return ServiceHelper.getBean(SingletonService.class).exists(archetype);
    }

    private static org.openvpms.component.model.object.IMObject match(String[] shortNames, Context context) {
        org.openvpms.component.model.object.IMObject result = null;
        org.openvpms.component.model.object.IMObject object = context.getCurrent();
        if (object != null) {
            for (String shortName : shortNames) {
                if (!object.isA(shortName)) continue;
                result = object;
                break;
            }
        }
        return result;
    }
}

