/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.DefaultIMObjectTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;

public class IMObjectTableModelFactory {
    private static ArchetypeHandlers<IMObjectTableModel<?>> models;
    private static final Logger log;

    private IMObjectTableModelFactory() {
    }

    public static <T extends IMObject> IMObjectTableModel<T> create(String[] shortNames, LayoutContext context) {
        return IMObjectTableModelFactory.create(shortNames, (IMObject)null, context);
    }

    public static <T extends IMObject> IMObjectTableModel<T> create(String[] shortNames, Query<T> query, LayoutContext context) {
        IMObjectTableModel<T> result = null;
        ArchetypeHandler handler = IMObjectTableModelFactory.getTableModels().getHandler(shortNames);
        if (handler != null) {
            result = IMObjectTableModelFactory.construct(handler, shortNames, query, null, context);
        }
        if (result == null) {
            result = new DefaultDescriptorTableModel<T>(shortNames, query, context, new String[0]);
        }
        return result;
    }

    public static <T extends IMObject> IMObjectTableModel<T> create(Class<? extends IMObjectTableModel<T>> type, LayoutContext context) {
        IMObjectTableModel result = null;
        ArchetypeHandler handler = IMObjectTableModelFactory.getTableModels().getHandler(type);
        if (handler != null) {
            result = IMObjectTableModelFactory.construct(handler, null, null, null, context);
        }
        if (result == null) {
            result = new DefaultIMObjectTableModel();
        }
        return result;
    }

    public static <T extends IMObject> IMObjectTableModel<T> create(String[] shortNames, IMObject parent, LayoutContext context) {
        IMObjectTableModel<T> result = null;
        ArchetypeHandler handler = IMObjectTableModelFactory.getTableModels().getHandler(shortNames);
        if (handler != null) {
            result = IMObjectTableModelFactory.construct(handler, shortNames, null, parent, context);
        }
        if (result == null) {
            result = new DefaultDescriptorTableModel(shortNames, context, new String[0]);
        }
        return result;
    }

    public static boolean hasModel(String[] archetypes, Class<? extends IMObjectTableModel> type) {
        ArchetypeHandler handler = IMObjectTableModelFactory.getTableModels().getHandler(archetypes);
        return handler != null && type.isAssignableFrom(handler.getType());
    }

    private static <T extends IMObject> IMObjectTableModel<T> construct(ArchetypeHandler<IMObjectTableModel<T>> handler, final String[] shortNames, Query<T> query, IMObject parent, LayoutContext context) {
        Class type = handler.getType();
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
        factory.setAutowireCandidateResolver((AutowireCandidateResolver)new SimpleAutowireCandidateResolver(){

            public Object getSuggestedValue(DependencyDescriptor descriptor) {
                if (String[].class.equals((Object)descriptor.getDependencyType())) {
                    return shortNames;
                }
                return super.getSuggestedValue(descriptor);
            }
        });
        if (query != null) {
            factory.registerSingleton("query", query);
        }
        if (parent != null) {
            factory.registerSingleton("parent", (Object)parent);
        }
        if (context != null) {
            factory.registerSingleton("context", (Object)context);
        }
        try {
            IMObjectTableModel result = (IMObjectTableModel)factory.createBean(type, 3, false);
            handler.initialise((Object)result);
            return result;
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            return null;
        }
    }

    private static synchronized ArchetypeHandlers<IMObjectTableModel<?>> getTableModels() {
        if (models == null) {
            models = new ArchetypeHandlers("IMObjectTableModelFactory", "DefaultIMObjectTableModelFactory", IMObjectTableModel.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return models;
    }

    static {
        log = LoggerFactory.getLogger(IMObjectTableModelFactory.class);
    }
}

