/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.openvpms.web.component.im.table.ListMarkModel;

public class DefaultListMarkModel
implements ListMarkModel {
    private final BitSet marks = new BitSet();
    private final List<ListMarkModel.Listener> listeners = new ArrayList<ListMarkModel.Listener>();

    @Override
    public void addListener(ListMarkModel.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ListMarkModel.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setMarked(int index, boolean mark) {
        if (this.marks.get(index) != mark) {
            this.marks.set(index, mark);
            for (ListMarkModel.Listener listener : this.getListeners()) {
                listener.changed(index, mark);
            }
        }
    }

    @Override
    public boolean isMarked(int index) {
        return this.marks.get(index);
    }

    @Override
    public void clear() {
        if (!this.marks.isEmpty()) {
            this.marks.clear();
            for (ListMarkModel.Listener listener : this.getListeners()) {
                listener.cleared();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.marks.isEmpty();
    }

    @Override
    public boolean canMark(int index) {
        return true;
    }

    private ListMarkModel.Listener[] getListeners() {
        return this.listeners.toArray(new ListMarkModel.Listener[0]);
    }
}

