/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.sms.SMSReplyUpdater;
import org.openvpms.web.component.im.table.AbstractIMObjectTableModel;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class SMSViewer {
    private final ArchetypeService service;
    private final SMSReplyUpdater replyUpdater;
    private final List<Act> messages = new ArrayList<Act>();
    private final Component component;

    public SMSViewer(List<Act> sms, ArchetypeService service, SMSReplyUpdater replyUpdater) {
        this.service = service;
        this.replyUpdater = replyUpdater;
        for (Act act : ActHelper.sort(sms)) {
            this.messages.add(act);
            IMObjectBean bean = service.getBean((IMObject)act);
            List replies = ActHelper.sort(bean.getTargets("replies", Act.class));
            this.messages.addAll(replies);
        }
        SMSTableModel model = new SMSTableModel();
        model.setObjects(this.messages);
        TableEx table = new TableEx();
        table.setModel((TableModel)model);
        table.setStyleName("SMSViewer.table");
        table.setColumnModel(model.getColumnModel());
        table.setHeaderVisible(false);
        if (!this.messages.isEmpty()) {
            table.setScrollToRow(this.messages.size() - 1);
        }
        this.component = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{table});
    }

    public Component getComponent() {
        return this.component;
    }

    public void markAsRead() {
        this.messages.stream().filter(act -> act.isA("act.smsReply")).forEach(this::markAsRead);
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    private void markAsRead(Act act) {
        this.replyUpdater.markRead(act);
    }

    private static class DateRenderer
    implements TableCellRenderer {
        private DateRenderer() {
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Label result;
            Act object = (Act)value;
            Date date = this.getDate(object);
            if (date != null) {
                result = LabelFactory.text((String)this.formatDate(date));
                result.setLayoutData((LayoutData)TableHelper.alignTop());
            } else {
                result = LabelFactory.create();
            }
            return result;
        }

        private Date getDate(Act object) {
            Date date = null;
            if (object.isA("act.smsMessage")) {
                date = object.getActivityEndTime();
            }
            if (date == null) {
                date = object.getActivityStartTime();
            }
            return date;
        }

        private String formatDate(Date date) {
            String text = "";
            if (!DateRules.isToday((Date)date)) {
                Date today;
                text = DateRules.isYesterday((Date)date) ? Messages.get((String)"date.format.yesterday") : (DateRules.between((Date)date, (Date)DateRules.getDate((Date)(today = DateRules.getToday()), (int)-6, (DateUnits)DateUnits.DAYS), (Date)today) ? DateFormatter.getDayFormat().format(date) : DateFormatter.getFullDateFormat().format(date));
                text = text + " ";
            }
            text = text + DateFormatter.getFullTimeFormat().format(date);
            return text;
        }
    }

    private class MessageRenderer
    implements TableCellRenderer {
        private MessageRenderer() {
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Act object = (Act)value;
            String message = SMSViewer.this.service.getBean((IMObject)object).getString("message");
            Label label = LabelFactory.create((boolean)true, (boolean)true);
            label.setText(message);
            String style = "SMSViewer.message";
            if (object.isA("act.smsReply")) {
                label.setTextAlignment(Alignment.ALIGN_LEFT);
                label.setLayoutData((LayoutData)TableHelper.alignRight());
                style = "SMSViewer.reply";
            }
            label.setStyleName(style);
            return label;
        }
    }

    private class SMSTableModel
    extends AbstractIMObjectTableModel<Act> {
        public SMSTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(new TableColumn(0, null, (TableCellRenderer)new DateRenderer(), null));
            model.addColumn(new TableColumn(1, null, (TableCellRenderer)new MessageRenderer(), null));
            this.setTableColumnModel((TableColumnModel)model);
        }

        @Override
        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        @Override
        protected Object getValue(Act object, TableColumn column, int row) {
            return object;
        }
    }
}

