/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.macro.Macros;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.macro.MacroVariables;

public class SMSTemplateEvaluator {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final Macros macros;

    public SMSTemplateEvaluator(ArchetypeService service, LookupService lookups, Macros macros) {
        this.service = service;
        this.lookups = lookups;
        this.macros = macros;
    }

    public String evaluate(Entity template, Object object, Context context) {
        MacroVariables variables = new MacroVariables(context, this.service, this.lookups);
        return this.evaluate(template, object, variables);
    }

    public String evaluate(Entity template, Object object, MacroVariables variables) {
        String result;
        IMObjectBean templateBean = this.service.getBean((IMObject)template);
        String type = templateBean.getString("contentType");
        String content = templateBean.getString("content");
        if (object == null) {
            object = new Object();
        }
        if ("XPATH".equals(type)) {
            variables.declareVariable("nl", "\n");
            JXPathContext jxPathContext = JXPathHelper.newContext((Object)object);
            jxPathContext.setVariables((Variables)variables);
            result = (String)jxPathContext.getValue(content, String.class);
        } else {
            result = "MACRO".equals(type) ? this.macros.runAll(content, object, (org.openvpms.component.system.common.util.Variables)variables, null, true) : content;
        }
        return result;
    }
}

