/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.party.Party;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.message.OutboundMessageBuilder;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.list.PairListModel;
import org.openvpms.web.component.im.sms.BoundSMSTextArea;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.PropertySetImpl;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.SMSTextArea;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class SMSEditor
extends AbstractModifiable {
    private final Context context;
    private final SMSTextArea message;
    private final SimpleProperty messageProperty;
    private final SimpleProperty phoneProperty;
    private final FocusGroup focus;
    private final Editors editors;
    private final ArchetypeService service;
    private final SMSService smsService;
    private TextField phone;
    private SelectField phoneSelector;
    private Contact selected;
    private int maxParts;
    private Act source;
    private static final String AD_HOC_SMS = "AD_HOC_SMS";

    public SMSEditor(Context context) {
        this(Collections.emptyList(), null, context, ServiceHelper.getSMSService());
    }

    public SMSEditor(List<Contact> contacts, Variables variables, Context context, SMSService smsService) {
        this.context = context;
        this.service = ServiceHelper.getArchetypeService();
        this.smsService = smsService;
        int length = contacts == null ? 0 : contacts.size();
        this.phoneProperty = new SimpleProperty("phone", null, String.class, Messages.get((String)"sms.phone"));
        this.phoneProperty.setRequired(true);
        if (length <= 1) {
            this.phone = BoundTextComponentFactory.create(this.phoneProperty, 20);
            if (length == 1) {
                this.onSelected(contacts.get(0));
                this.phoneProperty.setValue(this.formatPhone(this.selected));
                this.phone.setEnabled(false);
            }
        } else {
            final PairListModel model = this.formatPhones(contacts);
            this.phoneSelector = BoundSelectFieldFactory.create(this.phoneProperty, (ListModel)model);
            this.phoneSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    int index = SMSEditor.this.phoneSelector.getSelectedIndex();
                    if (index >= 0 && index < model.size()) {
                        SMSEditor.this.onSelected((Contact)model.getValue(index));
                    } else {
                        SMSEditor.this.onSelected(null);
                    }
                }
            });
            this.phoneSelector.setSelectedIndex(0);
        }
        this.messageProperty = new SimpleProperty("message", null, String.class, Messages.get((String)"sms.message"));
        this.messageProperty.setRequired(true);
        this.messageProperty.setMaxLength(-1);
        Macros macros = ServiceHelper.getMacros();
        this.messageProperty.setTransformer(new StringPropertyTransformer(this.messageProperty, false, macros, null, variables));
        this.message = new BoundSMSTextArea(this.messageProperty, 40, 15);
        this.message.setStyleName("default");
        this.focus = new FocusGroup("SMSEditor");
        if (this.phone != null && this.phone.isEnabled()) {
            this.focus.add((Component)this.phone);
        } else if (this.phoneSelector != null) {
            this.focus.add((Component)this.phoneSelector);
        }
        this.focus.add((Component)this.message);
        this.focus.setDefault((Component)this.message);
        PropertySetImpl properties = new PropertySetImpl(this.phoneProperty, this.messageProperty);
        this.editors = new Editors(properties, new ModifiableListeners());
        this.editors.addModifiableListener(modifiable -> this.resetValid());
        this.setMaxParts(1);
    }

    public void send() {
        String phone = this.getPhone();
        String message = this.getMessage();
        Party party = this.selected != null ? ((org.openvpms.component.business.domain.im.party.Contact)this.selected).getParty() : null;
        org.openvpms.component.model.party.Party customer = this.context.getCustomer();
        org.openvpms.component.model.party.Party patient = this.context.getPatient();
        org.openvpms.component.model.party.Party location = this.context.getLocation();
        OutboundMessage sms = ((OutboundMessageBuilder)((OutboundMessageBuilder)((OutboundMessageBuilder)this.smsService.getOutboundMessageBuilder().recipient((org.openvpms.component.model.party.Party)party).phone(phone)).message(message)).customer(customer).patient(patient).subject(Messages.get((String)"sms.log.adhoc.subject")).reason(AD_HOC_SMS).location(location)).source(IMObjectHelper.reload(this.source)).build();
        this.smsService.send(sms);
    }

    public String getPhone() {
        String result = this.phoneProperty.getString();
        if (result != null) {
            result = result.replaceAll("[\\s\\-()]", "").replaceAll("[^\\d+].*", "");
        }
        return result;
    }

    public void setMessage(String message) {
        this.messageProperty.setValue(message);
    }

    public void setMaxParts(int maxParts) {
        if (maxParts <= 0) {
            maxParts = 1;
        }
        this.maxParts = maxParts;
        this.message.setMaxParts(maxParts);
    }

    public void setSource(Act source) {
        this.source = source;
    }

    public Contact getContact() {
        return this.selected;
    }

    public String getMessage() {
        return this.messageProperty.getString();
    }

    public Component getComponent() {
        ComponentGrid grid = new ComponentGrid();
        this.layout(grid);
        return grid.createGrid();
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    @Override
    public boolean isModified() {
        return this.editors.isModified();
    }

    @Override
    public void clearModified() {
        this.editors.clearModified();
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.editors.addModifiableListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.editors.addModifiableListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.editors.removeModifiableListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.editors.setErrorListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.editors.getErrorListener();
    }

    @Override
    public void resetValid() {
        super.resetValid();
        this.editors.resetValid();
    }

    protected void layout(ComponentGrid grid) {
        grid.add(new Component[]{LabelFactory.create((String)"sms.phone"), this.phone != null ? this.phone : this.phoneSelector});
        grid.add(new Component[]{LabelFactory.create((String)"sms.message"), this.message});
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.editors.validate(validator) && this.validatePhone(validator) && this.validateMessage(validator);
    }

    private boolean validatePhone(Validator validator) {
        boolean valid = true;
        String phone = this.getPhone();
        if (phone == null || phone.isEmpty()) {
            valid = false;
            String error = Messages.format((String)"property.error.required", (Object[])new Object[]{this.phoneProperty.getDisplayName()});
            validator.add((Modifiable)this.phoneProperty, error);
        }
        return valid;
    }

    private boolean validateMessage(Validator validator) {
        boolean valid = true;
        String message = StringUtils.trimToEmpty((String)this.getMessage());
        if (message.isEmpty()) {
            String error = Messages.format((String)"property.error.required", (Object[])new Object[]{this.messageProperty.getDisplayName()});
            validator.add((Modifiable)this.messageProperty, error);
            valid = false;
        } else {
            int parts = this.smsService.getParts(message);
            if (parts > this.maxParts) {
                valid = false;
                String error = Messages.format((String)"sms.toolong", (Object[])new Object[]{parts, this.maxParts});
                validator.add((Modifiable)this, error);
            }
        }
        return valid;
    }

    private PairListModel formatPhones(List<Contact> contacts) {
        ArrayList<PairListModel.Pair> phones = new ArrayList<PairListModel.Pair>();
        PairListModel.Pair preferred = null;
        for (Contact contact : contacts) {
            String phone = this.formatPhone(contact);
            PairListModel.Pair pair = new PairListModel.Pair(phone, contact);
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            if (bean.getBoolean("preferred")) {
                preferred = pair;
            }
            phones.add(pair);
        }
        phones.sort((o1, o2) -> ComparatorUtils.nullLowComparator(null).compare(o1.getKey(), o2.getKey()));
        if (preferred != null && !((PairListModel.Pair)phones.get(0)).equals(preferred)) {
            phones.remove(preferred);
            phones.add(0, preferred);
        }
        return new PairListModel(phones);
    }

    private String formatPhone(Contact contact) {
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        String areaCode = bean.getString("areaCode");
        String phone = bean.getString("telephoneNumber");
        phone = !StringUtils.isEmpty((CharSequence)areaCode) ? Messages.format((String)"phone.withAreaCode", (Object[])new Object[]{areaCode, phone}) : Messages.format((String)"phone.noAreaCode", (Object[])new Object[]{phone});
        String name = contact.getName();
        if (!StringUtils.isEmpty((CharSequence)name) && bean.hasNode("name") && !bean.isDefaultValue("name")) {
            phone = phone + " (" + name + ")";
        }
        return phone;
    }

    private void onSelected(Contact selected) {
        this.selected = selected;
    }
}

