/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.layout.ColumnLayoutData;
import nextapp.echo2.app.layout.RowLayoutData;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.mail.MailMessage;
import org.openvpms.sms.internal.mail.MailMessageFactory;
import org.openvpms.sms.internal.mail.MailSMSProvider;
import org.openvpms.sms.internal.mail.template.MailTemplate;
import org.openvpms.sms.internal.mail.template.MailTemplateFactory;
import org.openvpms.sms.internal.mail.template.TemplatedMailMessageFactory;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.sms.SMSEditor;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class EmailSMSSampler
extends AbstractModifiable {
    private final Entity config;
    private final SMSEditor sms;
    private final TextField from;
    private final TextField to;
    private final TextArea text;
    private final MailTemplateFactory templateFactory;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private final Button send;
    private final Label status;
    private TextField replyTo;
    private TextField subject;
    private static final String SEND_SMS_ID = "sms.send";

    public EmailSMSSampler(Entity config) {
        this.config = config;
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)config);
        this.sms = new SMSEditor(new LocalContext());
        this.sms.setMessage(Messages.get((String)"sms.sample.message"));
        this.sms.addModifiableListener(modifiable -> this.refresh());
        this.from = TextComponentFactory.create((int)40);
        this.from.setStyleName("edit");
        this.from.setEnabled(false);
        this.to = TextComponentFactory.create((int)40);
        this.to.setStyleName("edit");
        this.to.setEnabled(false);
        if (bean.hasNode("replyTo") || bean.hasNode("replyToExpression")) {
            this.replyTo = TextComponentFactory.create((int)40);
            this.replyTo.setStyleName("edit");
            this.replyTo.setEnabled(false);
        }
        if (bean.hasNode("subject") || bean.hasNode("subjectExpression")) {
            this.subject = TextComponentFactory.create((int)40);
            this.subject.setStyleName("edit");
            this.subject.setEnabled(false);
        }
        this.text = TextComponentFactory.createTextArea((int)40, (int)15);
        this.text.setStyleName("edit");
        this.text.setEnabled(false);
        this.status = LabelFactory.create((boolean)true);
        this.templateFactory = new MailTemplateFactory((IArchetypeService)ServiceHelper.getArchetypeService());
        this.send = ButtonFactory.create((String)SEND_SMS_ID, () -> {
            if (this.isValid()) {
                this.sendSMS();
            }
        });
        this.refresh();
    }

    public FocusGroup getFocusGroup() {
        return this.sms.getFocusGroup();
    }

    @Override
    public boolean isModified() {
        return this.sms.isModified();
    }

    @Override
    public void clearModified() {
        this.sms.clearModified();
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
    }

    @Override
    public ErrorListener getErrorListener() {
        return null;
    }

    public Component getComponent() {
        Component smsEdit = this.sms.getComponent();
        Column editCol = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"sms.title", (String)"bold"), smsEdit, RowFactory.create((Component[])new Component[]{this.send})});
        Grid resultGrid = GridFactory.create((int)2, (Component[])new Component[]{LabelFactory.create((String)"sms.mail.from"), this.from, LabelFactory.create((String)"sms.mail.to"), this.to});
        if (this.replyTo != null) {
            resultGrid.add((Component)LabelFactory.create((String)"sms.mail.replyTo"));
            resultGrid.add((Component)this.replyTo);
        }
        if (this.subject != null) {
            resultGrid.add((Component)LabelFactory.create((String)"sms.mail.subject"));
            resultGrid.add((Component)this.subject);
        }
        resultGrid.add((Component)LabelFactory.create((String)"sms.mail.text"));
        resultGrid.add((Component)this.text);
        Column resultCol = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"sms.email.title", (String)"bold"), resultGrid});
        Column statusCol = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"sms.email.status.title", (String)"bold"), this.status});
        Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{editCol, resultCol, statusCol});
        RowLayoutData layout = new RowLayoutData();
        layout.setAlignment(Alignment.ALIGN_TOP);
        editCol.setLayoutData((LayoutData)layout);
        resultCol.setLayoutData((LayoutData)layout);
        statusCol.setLayoutData((LayoutData)layout);
        Label title = LabelFactory.create((String)"sms.sample.title", (String)"bold");
        ColumnLayoutData titleLayout = new ColumnLayoutData();
        titleLayout.setAlignment(Alignment.ALIGN_CENTER);
        title.setLayoutData((LayoutData)titleLayout);
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{title, row});
        return ColumnFactory.create((String)"Inset", (Component[])new Component[]{column});
    }

    public void sendSMS() {
        if (this.isValid()) {
            MailTemplate template = this.templateFactory.getTemplate(this.config);
            TemplatedMailMessageFactory factory = new TemplatedMailMessageFactory(template);
            MailSMSProvider provider = ServiceHelper.getBean(MailSMSProvider.class);
            provider.send(this.sms.getPhone(), this.sms.getMessage(), (MailMessageFactory)factory);
        }
    }

    public void refresh() {
        this.resetValid();
        String errorMessage = null;
        boolean valid = false;
        String fromStr = null;
        String toStr = null;
        String replyToStr = null;
        String subjectStr = null;
        String textStr = null;
        DefaultValidator validator = new DefaultValidator();
        try {
            if (this.validateConfig(validator)) {
                MailTemplate template = this.templateFactory.getTemplate(this.config);
                TemplatedMailMessageFactory factory = new TemplatedMailMessageFactory(template);
                MailMessage mail = factory.createMessage(this.sms.getPhone(), this.sms.getMessage());
                fromStr = mail.getFrom();
                toStr = mail.getTo();
                replyToStr = mail.getReplyTo();
                textStr = mail.getText();
                subjectStr = mail.getSubject();
                this.sms.setMaxParts(template.getMaxParts());
                valid = this.validate(validator);
            }
        }
        catch (SMSException exception) {
            errorMessage = exception.getI18nMessage().getMessage();
        }
        catch (Throwable exception) {
            errorMessage = exception.getLocalizedMessage();
        }
        this.from.setText(fromStr);
        this.to.setText(toStr);
        if (this.replyTo != null) {
            this.replyTo.setText(replyToStr);
        }
        if (this.subject != null) {
            this.subject.setText(subjectStr);
        }
        this.text.setText(textStr);
        this.send.setEnabled(valid);
        if (valid) {
            this.status.setText(Messages.get((String)"sms.email.status.ok"));
        } else if (errorMessage != null) {
            this.status.setText(errorMessage);
        } else {
            ValidatorError error = validator.getFirstError();
            if (error != null) {
                this.status.setText(error.getMessage());
            } else {
                this.status.setText(Messages.get((String)"sms.email.status.incomplete"));
            }
        }
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = false;
        if (this.validateConfig(validator) && validator.validate(this.sms)) {
            MailTemplate template = this.templateFactory.getTemplate(this.config);
            TemplatedMailMessageFactory factory = new TemplatedMailMessageFactory(template);
            try {
                String phone = this.sms.getPhone();
                String message = this.sms.getMessage();
                MailMessage mail = factory.createMessage(phone, message);
                if (!(StringUtils.isEmpty((CharSequence)mail.getFrom()) || StringUtils.isEmpty((CharSequence)mail.getTo()) || StringUtils.isEmpty((CharSequence)mail.getText()))) {
                    result = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean validateConfig(Validator validator) {
        boolean valid = true;
        List<ValidatorError> errors = ValidationHelper.validate((IMObject)this.config, (ArchetypeService)ServiceHelper.getArchetypeService());
        if (errors != null) {
            validator.add((Modifiable)this, errors);
            valid = false;
        }
        return valid;
    }
}

