/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.select;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.RowLayoutData;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;

public abstract class Selector<T> {
    public static final String BUTTON_ID = "button.select";
    private final String buttonId;
    private final boolean enableShortcuts;
    private Button select;
    private Label objectLabel;
    private TextField objectText;
    private boolean fillWidth;
    private final ButtonStyle buttonStyle;
    private final boolean editable;
    private Format format = Format.SUMMARY;
    private Component component;
    private Component child;
    private Label deactivated;
    private final FocusGroup focusGroup;

    public Selector() {
        this(ButtonStyle.LEFT, false);
    }

    public Selector(String buttonId) {
        this(buttonId, ButtonStyle.LEFT, false, true);
    }

    public Selector(ButtonStyle style, boolean editable) {
        this(BUTTON_ID, style, editable, true);
    }

    public Selector(String buttonId, ButtonStyle style, boolean editable, boolean enableShortcuts) {
        this.buttonId = buttonId;
        this.buttonStyle = style;
        this.editable = editable;
        this.enableShortcuts = enableShortcuts;
        this.focusGroup = new FocusGroup(ClassUtils.getShortClassName(this.getClass()));
    }

    public Component getComponent() {
        if (this.component == null) {
            this.doLayout();
        }
        return this.component;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public Button getSelect() {
        if (this.select == null) {
            this.select = this.createSelectButton(this.buttonId, this.enableShortcuts);
        }
        return this.select;
    }

    public TextField getTextField() {
        this.getObjectComponent();
        return this.objectText;
    }

    public String getText() {
        TextField field = this.getTextField();
        return field != null ? StringUtils.trimToNull((String)field.getText()) : null;
    }

    public abstract void setObject(T var1);

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setFillWidth(boolean fillWidth) {
        this.fillWidth = fillWidth;
        if (this.objectText != null) {
            this.objectText.setWidth(new Extent(100, 2));
        }
        if (this.component != null) {
            this.component.removeAll();
            this.doLayout(this.component);
        }
    }

    protected void setObject(String name, String description, boolean active) {
        String text = null;
        if (name != null || description != null) {
            if (this.format == Format.NAME || description == null) {
                text = Messages.format((String)"imobject.name", (Object[])new Object[]{name});
            } else if (this.format == Format.DESCRIPTION || name == null) {
                text = Messages.format((String)"imobject.description", (Object[])new Object[]{description});
            } else if (this.format == Format.SUMMARY) {
                text = Messages.format((String)"imobject.summary", (Object[])new Object[]{name, description});
            }
        }
        this.getComponent();
        if (this.objectText != null) {
            this.objectText.setText(text);
            if (this.objectText.isEnabled()) {
                int length;
                int n = length = text != null ? text.length() : 0;
                if (this.objectText.getCursorPosition() < length) {
                    this.objectText.setCursorPosition(length);
                }
            }
        } else {
            this.objectLabel.setText(text);
        }
        if (this.child != null) {
            if (!active) {
                if (this.deactivated == null) {
                    this.deactivated = LabelFactory.create((String)"imobject.deactivated", (String)"Selector.Deactivated");
                    this.child.add((Component)this.deactivated);
                }
            } else if (this.deactivated != null) {
                this.child.remove((Component)this.deactivated);
                this.deactivated = null;
            }
        }
    }

    protected void doLayout() {
        this.component = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        this.doLayout(this.component);
    }

    private void doLayout(Component container) {
        this.child = null;
        Component objectComponent = this.getObjectComponent();
        if (this.buttonStyle == ButtonStyle.RIGHT && this.fillWidth) {
            RowLayoutData layout = new RowLayoutData();
            layout.setWidth(Styles.FULL_WIDTH);
            container.add(objectComponent);
            objectComponent.setLayoutData((LayoutData)layout);
            this.child = RowFactory.create((Component[])new Component[]{this.getButtons(this.component)});
            container.add(objectComponent);
        } else if (this.buttonStyle == ButtonStyle.RIGHT) {
            this.child = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{RowFactory.create((Component[])new Component[]{objectComponent, this.getButtons(this.component)})});
        } else if (this.buttonStyle == ButtonStyle.LEFT) {
            this.child = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{objectComponent});
            this.child.add((Component)this.getButtons(this.child), 0);
        } else {
            container.add(objectComponent);
        }
        if (this.objectText != null) {
            if (this.buttonStyle == ButtonStyle.RIGHT) {
                this.focusGroup.add(0, (Component)this.objectText);
            } else {
                this.focusGroup.add((Component)this.objectText);
            }
        }
        if (this.child != null) {
            container.add(this.child);
        }
    }

    protected Component getObjectComponent() {
        TextField component;
        if (this.editable) {
            if (this.objectText == null) {
                this.objectText = TextComponentFactory.create();
                this.objectText.setStyleName("Selector");
                if (this.fillWidth) {
                    this.objectText.setWidth(Styles.FULL_WIDTH);
                }
            }
            component = this.objectText;
        } else {
            if (this.objectLabel == null) {
                this.objectLabel = LabelFactory.create();
            }
            component = this.objectLabel;
        }
        return component;
    }

    protected ButtonRow getButtons(Component container) {
        ButtonRow result = new ButtonRow(container, this.getFocusGroup());
        result.addButton(this.getSelect());
        return result;
    }

    protected Button createSelectButton(String buttonId, boolean enableShortcuts) {
        return ButtonFactory.create((String)buttonId, (boolean)enableShortcuts);
    }

    public static enum Format {
        NAME,
        DESCRIPTION,
        SUMMARY;

    }

    public static enum ButtonStyle {
        LEFT,
        RIGHT,
        NONE;

    }
}

