/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.select;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.error.DialogErrorHandler;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.Selector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.DialogManager;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.event.DocumentListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.focus.FocusCommand;
import org.openvpms.web.echo.text.TextField;

public abstract class AbstractQuerySelector<T>
extends Selector<T> {
    private final String type;
    private final DocumentListener textListener;
    private final LayoutContext context;
    private T object;
    private boolean allowCreate;
    private String prevText;
    private SelectorListener<T> listener;
    private boolean inSelect;

    public AbstractQuerySelector(String type, boolean allowCreate, LayoutContext context) {
        this(type, allowCreate, Selector.ButtonStyle.RIGHT, true, context);
    }

    public AbstractQuerySelector(String type, boolean allowCreate, Selector.ButtonStyle style, boolean editable, LayoutContext context) {
        super(style, editable);
        this.type = type;
        this.allowCreate = allowCreate;
        this.textListener = new DocumentListener(){

            public void onUpdate(DocumentEvent event) {
                AbstractQuerySelector.this.onTextChanged();
            }
        };
        this.context = context;
        this.setFormat(Selector.Format.NAME);
        this.getSelect().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractQuerySelector.this.onSelect();
            }
        });
        TextField text = this.getTextField();
        text.getDocument().addDocumentListener((nextapp.echo2.app.event.DocumentListener)this.textListener);
        text.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractQuerySelector.this.onTextAction();
            }
        });
    }

    @Override
    public void setObject(T object) {
        this.object = object;
        TextField text = this.getTextField();
        text.getDocument().removeDocumentListener((nextapp.echo2.app.event.DocumentListener)this.textListener);
        if (object != null) {
            super.setObject(this.getName(object), this.getDescription(object), this.getActive(object));
        } else {
            super.setObject(null, null, true);
        }
        text.getDocument().addDocumentListener((nextapp.echo2.app.event.DocumentListener)this.textListener);
        this.prevText = text.getText();
    }

    public T getObject() {
        return this.object;
    }

    public void setListener(SelectorListener<T> listener) {
        this.listener = listener;
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = !this.inSelect;
        if (valid) {
            String text = this.getText();
            valid = this.object != null ? Objects.equals(this.getName(this.object), text) : StringUtils.isEmpty((CharSequence)text);
        }
        return valid;
    }

    public boolean inSelect() {
        return this.inSelect;
    }

    public void setAllowCreate(boolean create) {
        this.allowCreate = create;
    }

    public boolean allowCreate() {
        return this.allowCreate;
    }

    public String getType() {
        return this.type;
    }

    protected abstract String getName(T var1);

    protected abstract String getDescription(T var1);

    protected abstract boolean getActive(T var1);

    protected void onSelect(boolean runQuery) {
        try {
            final FocusCommand focus = new FocusCommand();
            String text = this.getText();
            if (StringUtils.isEmpty((CharSequence)text)) {
                text = null;
            }
            final Browser<T> browser = this.createBrowser(text, runQuery);
            final BrowserDialog<T> popup = this.createDialog(browser);
            popup.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    focus.restore();
                    AbstractQuerySelector.this.setInSelect(false);
                    if (popup.createNew()) {
                        AbstractQuerySelector.this.onCreate();
                    } else {
                        Object object = popup.getSelected();
                        if (object != null) {
                            AbstractQuerySelector.this.onSelected(object, browser);
                        }
                    }
                }
            });
            this.setInSelect(true);
            popup.show();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    protected void onSelected(T object, Browser<T> browser) {
        T current = this.getObject();
        this.setObject(object);
        this.getFocusGroup().setFocus();
        if (this.listener != null && !Objects.equals(current, object)) {
            this.listener.selected(object, browser);
        }
    }

    protected void onCreate() {
        if (this.listener != null) {
            this.listener.create();
        }
    }

    protected abstract Browser<T> createBrowser(String var1, boolean var2);

    protected BrowserDialog<T> createDialog(Browser<T> browser) {
        return new BrowserDialog<T>(this.type, browser, this.allowCreate, this.context.getHelpContext());
    }

    protected abstract ResultSet<T> getMatches(String var1);

    @Override
    protected Button createSelectButton(String buttonId, boolean enableShortcuts) {
        Button select = ButtonFactory.create(null, (String)"select");
        select.setId(buttonId);
        return select;
    }

    protected LayoutContext getContext() {
        return this.context;
    }

    protected void onTextChanged() {
        String text = this.getText();
        if (!Objects.equals(text, this.prevText)) {
            if (StringUtils.isEmpty((CharSequence)text)) {
                this.setObject(null);
                this.notifySelected();
            } else {
                try {
                    ResultSet<T> set = this.getMatches(text);
                    if (set != null && set.hasNext()) {
                        IPage page = (IPage)set.next();
                        List rows = page.getResults();
                        int size = rows.size();
                        if (size == 0) {
                            this.setObject(null);
                            this.notifySelected();
                        } else if (size == 1) {
                            Object object = rows.get(0);
                            this.setObject(object);
                            this.notifySelected();
                        } else if (this.canSelect()) {
                            this.onSelect(true);
                        }
                    }
                }
                catch (OpenVPMSException exception) {
                    ErrorHelper.show(exception);
                    this.listener.selected(null);
                }
            }
        }
    }

    private void onSelect() {
        if (this.canSelect()) {
            this.onSelect(false);
        }
    }

    private void onTextAction() {
        if (!this.isValid() || StringUtils.isEmpty((CharSequence)this.getText())) {
            this.onSelect();
        }
    }

    private void setInSelect(boolean select) {
        this.inSelect = select;
    }

    private void notifySelected() {
        if (this.listener != null) {
            this.listener.selected(this.getObject());
        }
    }

    private boolean canSelect() {
        return !this.inSelect && !this.inError() && !DialogManager.isHidden((Component)this.getComponent());
    }

    private boolean inError() {
        ErrorHandler handler = ErrorHandler.getInstance();
        return handler instanceof DialogErrorHandler && ((DialogErrorHandler)handler).inError();
    }
}

