/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.system.ServiceHelper;

public class DocumentActTemplateLocator
implements DocumentTemplateLocator {
    private final DocumentAct act;
    private final ArchetypeService service;
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";

    public DocumentActTemplateLocator(DocumentAct act) {
        this(act, (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    public DocumentActTemplateLocator(DocumentAct act, ArchetypeService service) {
        this.act = act;
        this.service = service;
    }

    @Override
    public DocumentTemplate getTemplate() {
        Entity template;
        DocumentTemplate result = null;
        IMObjectBean bean = this.service.getBean((IMObject)this.act);
        if (bean.hasNode(DOCUMENT_TEMPLATE) && (template = (Entity)bean.getTarget(DOCUMENT_TEMPLATE, Entity.class)) != null) {
            result = new DocumentTemplate(template, this.service);
        }
        return result;
    }

    @Override
    public String getType() {
        return this.act.getArchetype();
    }
}

