/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.button.ButtonColumn;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.style.Styles;

public abstract class SequencedTable<T> {
    private ButtonColumn moveButtons;
    private final PagedIMTable<T> table;
    private static final String MOVEUP_ID = "moveup";
    private static final String MOVEDOWN_ID = "movedown";

    public SequencedTable(PagedIMTable<T> table) {
        this.table = table;
    }

    public abstract List<T> getObjects();

    public void layout(Component container, FocusGroup focusGroup) {
        focusGroup.add(this.table.getFocusGroup());
        this.moveButtons = new ButtonColumn(focusGroup);
        this.moveButtons.addButton(MOVEUP_ID, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                SequencedTable.this.onMoveUp();
            }
        });
        this.moveButtons.addButton(MOVEDOWN_ID, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                SequencedTable.this.onMoveDown();
            }
        });
        this.table.getTable().setWidth(Styles.FULL_WIDTH);
        Row row = RowFactory.create((Component[])new Component[]{this.moveButtons});
        GridLayoutData alignTop = new GridLayoutData();
        alignTop.setAlignment(Alignment.ALIGN_TOP);
        row.setLayoutData((LayoutData)alignTop);
        this.table.getComponent().setLayoutData((LayoutData)alignTop);
        Grid grid = GridFactory.create((int)2, (Component[])new Component[]{this.table.getComponent(), row});
        grid.setWidth(Styles.FULL_WIDTH);
        container.add((Component)grid);
    }

    public void enableNavigation(boolean enable) {
        if (this.moveButtons != null) {
            T object = this.table.getSelected();
            boolean moveUp = false;
            boolean moveDown = false;
            if (enable && object != null) {
                List<T> objects = this.getObjects();
                int index = objects.indexOf(object);
                if (index > 0) {
                    moveUp = true;
                }
                if (index < objects.size() - 1) {
                    moveDown = true;
                }
            }
            this.moveButtons.getButtons().setEnabled(MOVEUP_ID, moveUp);
            this.moveButtons.getButtons().setEnabled(MOVEDOWN_ID, moveDown);
        }
    }

    public abstract void swap(T var1, T var2);

    private void onMoveUp() {
        int index;
        T selected = this.table.getTable().getSelected();
        if (selected != null && (index = this.getObjects().indexOf(selected)) > 0) {
            this.swap(index, index - 1);
        }
    }

    private void onMoveDown() {
        List<T> objects;
        int index;
        T selected = this.table.getTable().getSelected();
        if (selected != null && (index = (objects = this.getObjects()).indexOf(selected)) < objects.size() - 1) {
            this.swap(index, index + 1);
        }
    }

    private void swap(int index1, int index2) {
        List<T> objects = this.getObjects();
        T r1 = objects.get(index1);
        T r2 = objects.get(index2);
        if (r1 != null && r2 != null) {
            this.swap(r1, r2);
        }
    }
}

