/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.system.ServiceHelper;

public class SequencedRelationshipCollectionHelper {
    public static <T extends IMObject> List<T> sortByNode(List<T> objects) {
        IMObjectSorter.sort(objects, "sequence", "id");
        return objects;
    }

    public static <T extends SequencedRelationship> List<T> sort(List<T> objects) {
        objects.sort(SequencedRelationshipCollectionHelper::compare);
        return objects;
    }

    public static void sortStates(List<RelationshipState> states) {
        states.sort(SequenceComparator.INSTANCE);
    }

    public static boolean hasSequenceNode(String[] shortNames) {
        boolean hasSequence = true;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (String shortName : shortNames) {
            ArchetypeDescriptor descriptor = service.getArchetypeDescriptor(shortName);
            if (descriptor == null || descriptor.getNodeDescriptor("sequence") != null) continue;
            hasSequence = false;
            break;
        }
        return hasSequence;
    }

    public static void sequenceStates(List<RelationshipState> states) {
        int last = -1;
        for (RelationshipState state : states) {
            Relationship object = state.getRelationship();
            last = SequencedRelationshipCollectionHelper.sequence((IMObject)object, last);
        }
    }

    public static <T extends IMObject> void sequence(Collection<T> objects) {
        int last = -1;
        for (IMObject object : objects) {
            last = SequencedRelationshipCollectionHelper.sequence(object, last);
        }
    }

    public static <T extends SequencedRelationship> List<Map.Entry<IMObject, T>> sort(Map<IMObject, T> map) {
        ArrayList<Map.Entry<IMObject, T>> entries = new ArrayList<Map.Entry<IMObject, T>>(map.entrySet());
        entries.sort((o1, o2) -> {
            SequencedRelationship r1 = (SequencedRelationship)o1.getValue();
            SequencedRelationship r2 = (SequencedRelationship)o2.getValue();
            return SequencedRelationshipCollectionHelper.compare(r1, r2);
        });
        return entries;
    }

    public static <T extends IMObject> int getNextSequence(Collection<T> objects) {
        int last = -1;
        for (IMObject object : objects) {
            int sequence;
            if (!(object instanceof SequencedRelationship) || (sequence = ((SequencedRelationship)object).getSequence()) <= last) continue;
            last = sequence;
        }
        return last + 1;
    }

    private static <T extends SequencedRelationship> int compare(T x, T y) {
        int compare = Integer.compare(x.getSequence(), y.getSequence());
        if (compare == 0 && (compare = Long.compare(x.getId(), y.getId())) == 0) {
            compare = x.getLinkId().compareTo(y.getLinkId());
        }
        return compare;
    }

    private static int sequence(IMObject object, int last) {
        if (object instanceof SequencedRelationship) {
            SequencedRelationship relationship = (SequencedRelationship)object;
            if (last != -1 && relationship.getSequence() <= last) {
                relationship.setSequence(++last);
            } else {
                last = relationship.getSequence();
            }
        }
        return last;
    }

    private static class SequenceComparator
    implements Comparator<RelationshipState> {
        public static SequenceComparator INSTANCE = new SequenceComparator();

        private SequenceComparator() {
        }

        @Override
        public int compare(RelationshipState o1, RelationshipState o2) {
            SequencedRelationship r1 = (SequencedRelationship)o1.getRelationship();
            SequencedRelationship r2 = (SequencedRelationship)o2.getRelationship();
            return Integer.compare(r1.getSequence(), r2.getSequence());
        }
    }
}

