/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectTableCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.resource.i18n.Messages;

public class RelationshipCollectionTargetViewer
extends IMObjectTableCollectionViewer {
    private CheckBox hideInactive;

    public RelationshipCollectionTargetViewer(CollectionProperty property, IMObject parent, LayoutContext context) {
        super(property, parent, context);
    }

    @Override
    protected void browse(IMObject object) {
        Relationship relationship = (Relationship)object;
        IMObject target = this.getLayoutContext().getCache().get(relationship.getTarget());
        if (target != null) {
            super.browse(target);
        }
    }

    @Override
    protected Component doLayout() {
        String name = this.getProperty().getDisplayName();
        String label = Messages.format((String)"relationship.hide.inactive", (Object[])new Object[]{name});
        this.hideInactive = CheckBoxFactory.create(null, (boolean)true);
        this.hideInactive.setText(label);
        this.hideInactive.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RelationshipCollectionTargetViewer.this.onHideInactiveChanged();
            }
        });
        Component component = super.doLayout();
        component.add((Component)this.hideInactive, 0);
        return component;
    }

    protected boolean hideInactive() {
        return this.hideInactive.isSelected();
    }

    private void onHideInactiveChanged() {
        this.populateTable();
    }
}

