/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeList;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.relationship.AbstractRemovableCollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipCollectionTargetPropertyEditor<R extends Relationship>
extends AbstractRemovableCollectionPropertyEditor {
    private final IMObject parent;
    private final String[] relationshipShortNames;
    private final IMObjects objects;
    private Map<IMObject, R> targets;
    private boolean modified;
    private String relationshipShortName;
    private static final Logger log = LoggerFactory.getLogger(RelationshipCollectionTargetPropertyEditor.class);

    public RelationshipCollectionTargetPropertyEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        super(property);
        this.relationshipShortNames = property.getArchetypeRange();
        this.relationshipShortName = this.relationshipShortNames[0];
        this.parent = parent;
        this.objects = objects;
    }

    public IMObject getParent() {
        return this.parent;
    }

    public String[] getRelationshipShortNames() {
        return this.relationshipShortNames;
    }

    public String getRelationshipShortName() {
        return this.relationshipShortName;
    }

    public void setRelationshipShortName(String shortName) {
        this.relationshipShortName = shortName;
    }

    @Override
    public String[] getArchetypeRange() {
        return RelationshipHelper.getTargetShortNames((ArchetypeService)this.getService(), this.relationshipShortNames);
    }

    @Override
    public ArchetypeRange getArchetypes() {
        return new ArchetypeList(this.getArchetypeRange());
    }

    @Override
    public boolean add(IMObject object) {
        boolean added = false;
        Object relationship = (Relationship)this.getTargets().get(object);
        if (relationship == null) {
            try {
                relationship = this.addRelationship(this.parent, object, this.relationshipShortName);
                if (relationship != null) {
                    this.getTargets().put(object, relationship);
                    this.getProperty().add(relationship);
                    added = true;
                }
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show(exception);
            }
        }
        this.addEdited(object);
        return added;
    }

    @Override
    public boolean isModified() {
        return this.modified || super.isModified();
    }

    @Override
    public void clearModified() {
        this.modified = false;
        super.clearModified();
    }

    public List<IMObject> getObjects() {
        return new ArrayList<IMObject>(this.getTargets().keySet());
    }

    public R getRelationship(IMObject target) {
        return (R)((Relationship)this.getTargets().get(target));
    }

    public List<R> getRelationships() {
        return new ArrayList<R>(this.getTargets().values());
    }

    @Override
    protected boolean contains(IMObject object) {
        return this.getTargets().containsKey(object);
    }

    @Override
    protected void remove(IMObject object, IMObjectEditor editor) {
        this.queueRemove(object, editor);
        Relationship relationship = (Relationship)this.getTargets().remove(object);
        if (relationship != null) {
            this.removeRelationship(this.parent, object, relationship);
        }
    }

    protected abstract R addRelationship(IMObject var1, IMObject var2, String var3);

    protected abstract boolean removeRelationship(IMObject var1, IMObject var2, R var3);

    protected Map<IMObject, R> getTargets() {
        if (this.targets == null) {
            List relationships = super.getObjects();
            this.targets = new LinkedHashMap<IMObject, R>();
            for (Relationship relationship : relationships) {
                IMObject target;
                IMObject iMObject = target = relationship.getTarget() != null ? this.objects.get(relationship.getTarget()) : null;
                if (target != null) {
                    this.targets.put(target, relationship);
                    if (!relationship.isNew() && !target.isNew()) continue;
                    this.modified = true;
                    continue;
                }
                log.warn("Target object=" + relationship.getTarget() + " doesn't exist. Referred to by relationship=" + relationship);
                this.getProperty().remove(relationship);
            }
        }
        return this.targets;
    }
}

