/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.SequencedRelationshipCollectionHelper;
import org.openvpms.web.component.im.view.IMObjectTableCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;

public class IMObjectRelationshipCollectionViewer
extends IMObjectTableCollectionViewer {
    private final boolean sequenced;

    public IMObjectRelationshipCollectionViewer(CollectionProperty property, IMObject parent, LayoutContext layout) {
        super(property, parent, layout);
        this.sequenced = SequencedRelationshipCollectionHelper.hasSequenceNode(property.getArchetypeRange());
    }

    protected boolean isSequenced() {
        return this.sequenced;
    }

    @Override
    protected void browse(IMObject object) {
        Relationship relationship = (Relationship)object;
        IMObject target = this.getLayoutContext().getCache().get(relationship.getTarget());
        if (target != null) {
            this.browseTarget(target);
        }
    }

    protected void browseTarget(IMObject target) {
        super.browse(target);
    }

    @Override
    protected ResultSet<IMObject> createResultSet() {
        ResultSet<IMObject> result = this.isSequenced() ? new IMObjectListResultSet<IMObject>(this.getSorted(), 15) : super.createResultSet();
        return result;
    }

    protected List<IMObject> getSorted() {
        return SequencedRelationshipCollectionHelper.sortByNode(this.getObjects());
    }
}

