/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.IMObjectRelationshipCollectionViewer;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.im.table.IMObjectTableModelFactory;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;

public class IMObjectRelationshipCollectionTargetViewer
extends IMObjectRelationshipCollectionViewer {
    private final IArchetypeService service;
    private final String node;

    public IMObjectRelationshipCollectionTargetViewer(CollectionProperty property, IMObject parent, LayoutContext layout) {
        this(property, parent, "target", layout);
    }

    public IMObjectRelationshipCollectionTargetViewer(CollectionProperty property, IMObject parent, String node, LayoutContext layout) {
        super(property, parent, layout);
        this.node = node;
        this.service = ServiceHelper.getArchetypeService();
    }

    @Override
    protected void browse(IMObject object) {
        this.browseTarget(object);
    }

    @Override
    protected ResultSet<IMObject> createResultSet() {
        List<IMObject> relationships = this.isSequenced() ? this.getSorted() : this.getObjects();
        List objects = RelationshipHelper.getTargets(relationships, (ArchetypeService)this.service);
        return new IMObjectListResultSet<IMObject>(objects, 15);
    }

    @Override
    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        String[] archetypes = DescriptorHelper.getNodeShortNames((String[])this.getProperty().getArchetypeRange(), (String)this.node, (ArchetypeService)this.service);
        return IMObjectTableModelFactory.create(archetypes, this.getObject(), context);
    }
}

