/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.query.ResultSet;

public class ResultSetIterator<T>
implements ListIterator<T> {
    private final ResultSet<T> set;
    private ListIterator<T> pageIterator;
    private int initialOffset;
    private int firstResult = -1;
    private int pageIndex;
    private int count;
    private int last = -1;

    public ResultSetIterator(ResultSet<T> set) {
        this((ResultSet<int>)set, -1);
    }

    public ResultSetIterator(ResultSet<T> set, int offset) {
        this.set = set;
        this.initialOffset = offset;
        if (this.initialOffset != -1) {
            this.moveNext();
        }
    }

    public ResultSetIterator(ResultSet<T> set, T first) {
        IPage<T> page;
        this.set = set;
        int lastPage = set.lastIndex();
        if (lastPage != -1 && (page = set.getPage(lastPage)) != null) {
            this.initialOffset = page.getResults().indexOf(first);
            if (this.initialOffset != -1) {
                this.moveNext();
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.pageIterator == null || !this.pageIterator.hasNext()) {
            this.moveNext();
        }
        return this.pageIterator != null && this.pageIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        if (this.pageIterator == null || !this.pageIterator.hasPrevious()) {
            this.movePrevious();
        }
        return this.pageIterator != null && this.pageIterator.hasPrevious();
    }

    @Override
    public T next() {
        if (!(this.pageIterator != null && this.pageIterator.hasNext() || this.moveNext())) {
            throw new NoSuchElementException();
        }
        int lastIndex = this.nextIndex();
        T result = this.pageIterator.next();
        this.last = lastIndex;
        return result;
    }

    @Override
    public T previous() {
        if (!(this.pageIterator != null && this.pageIterator.hasPrevious() || this.movePrevious())) {
            throw new NoSuchElementException();
        }
        int lastIndex = this.previousIndex();
        T result = this.pageIterator.previous();
        this.last = lastIndex;
        return result;
    }

    @Override
    public int nextIndex() {
        int offset = this.pageIterator == null ? 0 : this.pageIterator.nextIndex();
        return this.pageIndex >= 0 ? this.set.getPageSize() * this.pageIndex + offset : -1;
    }

    @Override
    public int previousIndex() {
        int offset = this.pageIterator == null || !this.pageIterator.hasPrevious() ? (this.set.hasNext() ? this.set.getPageSize() - 1 : this.count - 1) : this.pageIterator.previousIndex();
        return this.pageIndex >= 0 ? this.set.getPageSize() * this.pageIndex + offset : -1;
    }

    public int lastIndex() {
        return this.last;
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean moveNext() {
        boolean result = false;
        Object page = null;
        if (this.set.hasNext() && this.firstResult == (page = (IPage)this.set.next()).getFirstResult()) {
            page = this.set.hasNext() ? (IPage)this.set.next() : null;
        }
        this.pageIndex = this.set.lastIndex();
        if (page != null) {
            this.pageIterator = page.getResults().listIterator();
            this.count = page.getResults().size();
            if (this.initialOffset != -1) {
                while (this.pageIterator.hasNext() && this.pageIterator.nextIndex() != this.initialOffset) {
                    this.pageIterator.next();
                }
                this.initialOffset = -1;
            }
            this.firstResult = page.getFirstResult();
            result = true;
        }
        return result;
    }

    private boolean movePrevious() {
        boolean result = false;
        Object page = null;
        if (this.set.hasPrevious() && this.firstResult == (page = (IPage)this.set.previous()).getFirstResult()) {
            page = this.set.hasPrevious() ? (IPage)this.set.previous() : null;
        }
        this.pageIndex = this.set.lastIndex();
        if (page != null) {
            List list = page.getResults();
            this.pageIterator = list.listIterator(list.size());
            this.firstResult = page.getFirstResult();
            result = true;
        }
        return result;
    }
}

