/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Iterator;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryListener;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class QueryAdapter<A, T>
implements Query<T> {
    private final Query<A> query;
    private final Class type;

    public QueryAdapter(Query<A> query, Class type) {
        this.query = query;
        this.type = type;
    }

    @Override
    public Component getComponent() {
        return this.query.getComponent();
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.query.setMaxResults(maxResults);
    }

    @Override
    public int getMaxResults() {
        return this.query.getMaxResults();
    }

    @Override
    public void setDefaultSortConstraint(SortConstraint[] sort) {
        this.query.setDefaultSortConstraint(sort);
    }

    @Override
    public SortConstraint[] getDefaultSortConstraint() {
        return this.query.getDefaultSortConstraint();
    }

    @Override
    public ResultSet<T> query() {
        ResultSet<A> set = this.query.query();
        return set != null ? this.convert(set) : null;
    }

    @Override
    public ResultSet<T> query(SortConstraint[] sort) {
        ResultSet<A> set = this.query.query(sort);
        return set != null ? this.convert(set) : null;
    }

    @Override
    public boolean selects(T object) {
        for (T next : this) {
            if (!next.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean selects(Reference reference) {
        return this.query.selects(reference);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.getDefaultSortConstraint());
    }

    @Override
    public Iterator<T> iterator(SortConstraint[] sort) {
        return new ResultSetIterator<T>(this.query(sort));
    }

    @Override
    public String[] getShortNames() {
        return this.query.getShortNames();
    }

    @Override
    public void setValue(String name) {
        this.query.setValue(name);
    }

    @Override
    public String getValue() {
        return this.query.getValue();
    }

    @Override
    public void setContains(boolean contains) {
        this.query.setContains(contains);
    }

    @Override
    public boolean isContains() {
        return this.query.isContains();
    }

    @Override
    public void setValueMinLength(int length) {
        this.query.setValueMinLength(length);
    }

    @Override
    public int getValueMinLength() {
        return this.query.getValueMinLength();
    }

    @Override
    public void setAuto(boolean auto) {
        this.query.setAuto(auto);
    }

    @Override
    public boolean isAuto() {
        return this.query.isAuto();
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
    }

    @Override
    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.query.addQueryListener(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.query.removeQueryListener(listener);
    }

    @Override
    public void setConstraints(IConstraint constraints) {
        this.query.setConstraints(constraints);
    }

    @Override
    public QueryState getQueryState() {
        return this.query.getQueryState();
    }

    @Override
    public void setQueryState(QueryState state) {
        this.query.setQueryState(state);
    }

    @Override
    public BaseArchetypeConstraint.State getActive() {
        return this.getQuery().getActive();
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.query.getFocusGroup();
    }

    public Query<A> getQuery() {
        return this.query;
    }

    @Override
    public Extent getHeight() {
        return this.query.getHeight();
    }

    protected abstract ResultSet<T> convert(ResultSet<A> var1);
}

