/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import org.apache.commons.collections.Transformer;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractListResultSet;
import org.openvpms.web.component.im.util.IMObjectSorter;

public class IMObjectListResultSet<T extends IMObject>
extends AbstractListResultSet<T> {
    private final Transformer transformer;
    private SortConstraint[] sort = EMPTY;
    private boolean sortAscending = true;
    private static final SortConstraint[] EMPTY = new SortConstraint[0];

    public IMObjectListResultSet(List<T> objects, int pageSize) {
        this(objects, pageSize, null);
    }

    public IMObjectListResultSet(List<T> objects, int pageSize, Transformer transformer) {
        this(objects, pageSize, null, transformer);
    }

    public IMObjectListResultSet(List<T> objects, int pageSize, SortConstraint[] sort, Transformer transformer) {
        super(objects, pageSize);
        if (sort != null) {
            this.sort = sort;
            if (sort.length > 0) {
                this.sortAscending = sort[0].isAscending();
            }
        }
        this.transformer = transformer;
    }

    @Override
    public void sort(SortConstraint[] sort) {
        if (sort != null && sort.length > 0 && !this.getObjects().isEmpty()) {
            if (this.transformer != null) {
                IMObjectSorter.sort(this.getObjects(), sort, this.transformer);
            } else {
                IMObjectSorter.sort(this.getObjects(), sort);
            }
            this.sortAscending = sort[0].isAscending();
        }
        this.sort = sort;
        this.reset();
    }

    @Override
    public boolean isSortedAscending() {
        return this.sortAscending;
    }

    @Override
    public SortConstraint[] getSortConstraints() {
        return this.sort != null ? this.sort : EMPTY;
    }
}

