/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import echopointng.DateChooser;
import echopointng.DateField;
import echopointng.model.CalendarEvent;
import echopointng.model.CalendarSelectionListener;
import echopointng.model.CalendarSelectionModel;
import java.util.Calendar;
import java.util.Date;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.web.component.im.query.DateNavigator;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.DateFieldFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public class DateSelector {
    private final DateField date;
    private final FocusGroup focus;
    private final CalendarSelectionListener calendarListener;
    private Date lastDate;
    private ActionListener listener;
    private ActionListener currentDateListener;
    private Component component;
    private DateNavigator navigator = DateNavigator.DAY;

    public DateSelector() {
        this.date = DateFieldFactory.create();
        this.calendarListener = new CalendarSelectionListener(){

            public void selectedDateChange(CalendarEvent event) {
                DateSelector.this.onDateChanged();
            }

            public void displayedDateChange(CalendarEvent event) {
            }
        };
        this.date.getModel().addListener(this.calendarListener);
        this.focus = new FocusGroup("dateSelector");
    }

    public void setDate(Date date) {
        date = this.navigator.getDate(date);
        this.setDateInternal(date);
    }

    public Date getDate() {
        Date datetime = this.date.getDateChooser().getSelectedDate().getTime();
        return DateRules.getDate((Date)datetime);
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setCurrentDateListener(ActionListener listener) {
        this.currentDateListener = listener;
    }

    public void setNavigator(DateNavigator navigator) {
        this.navigator = navigator;
        this.setDate(this.getDate());
    }

    public Component getComponent() {
        if (this.component == null) {
            this.doLayout();
        }
        return this.component;
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    private void onDateChanged() {
        Date date = this.getDate();
        Date modified = this.navigator.getDate(date);
        if (!modified.equals(date)) {
            this.setDateInternal(modified);
        }
        if (!date.equals(this.lastDate)) {
            this.lastDate = date;
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent((Object)this, "date"));
            }
        } else if (this.currentDateListener != null) {
            this.currentDateListener.actionPerformed(new ActionEvent((Object)this, "date"));
        }
    }

    private void setDateInternal(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CalendarSelectionModel model = this.date.getModel();
        model.removeListener(this.calendarListener);
        DateChooser dateChooser = this.date.getDateChooser();
        dateChooser.setSelectedDate(calendar);
        dateChooser.setDisplayedDate(calendar);
        model.addListener(this.calendarListener);
    }

    private void doLayout() {
        Button prevWeek = ButtonFactory.create(null, (String)"date.previousWeek", () -> this.update(this.navigator.getPreviousTerm(this.getDate())));
        Button prevDay = ButtonFactory.create(null, (String)"date.previousDay", () -> this.update(this.navigator.getPrevious(this.getDate())));
        Button currentDay = ButtonFactory.create(null, (String)"date.currentDay", () -> this.update(this.navigator.getCurrent()));
        Button nextDay = ButtonFactory.create(null, (String)"date.nextDay", () -> this.update(this.navigator.getNext(this.getDate())));
        Button nextWeek = ButtonFactory.create(null, (String)"date.nextWeek", () -> this.update(this.navigator.getNextTerm(this.getDate())));
        this.focus.add((Component)prevWeek);
        this.focus.add((Component)prevDay);
        this.focus.add((Component)this.date);
        this.focus.add((Component)currentDay);
        this.focus.add((Component)nextDay);
        this.focus.add((Component)nextWeek);
        this.component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{prevWeek, prevDay, this.date, currentDay, nextDay, nextWeek});
    }

    private void update(Date date) {
        this.setDateInternal(date);
        this.onDateChanged();
    }
}

