/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ActQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.ModifiableListener;

public abstract class DateRangeActQuery<T extends Act>
extends ActQuery<T> {
    private final boolean selectType;
    private final ModifiableListener dateRangeListener = modifiable -> this.onQuery();
    private DateRange dateRange;

    public DateRangeActQuery(String[] shortNames, ActStatuses statuses, Class<T> type) {
        this(null, null, null, shortNames, statuses, type);
    }

    public DateRangeActQuery(Entity entity, String participant, String participation, String[] shortNames, ActStatuses statuses, Class<T> type) {
        super(entity, participant, participation, shortNames, statuses, type);
        this.selectType = true;
        QueryFactory.initialise(this);
    }

    public DateRangeActQuery(Entity entity, String participant, String participation, String[] shortNames, Class<T> type) {
        this(entity, participant, participation, shortNames, true, new String[0], type);
    }

    public DateRangeActQuery(Entity entity, String participant, String participation, String[] shortNames, String[] statuses, Class<T> type) {
        this(entity, participant, participation, shortNames, true, statuses, type);
    }

    public DateRangeActQuery(Entity entity, String participant, String participation, String[] shortNames, boolean primaryOnly, String[] statuses, Class<T> type) {
        super(entity, participant, participation, shortNames, primaryOnly, statuses, type);
        this.selectType = true;
        QueryFactory.initialise(this);
    }

    public boolean getAllDates() {
        return this.getDateRange().getAllDates();
    }

    public void setAllDates(boolean selected) {
        DateRange dateRange = this.getDateRange();
        dateRange.removeListener(this.dateRangeListener);
        dateRange.setAllDates(selected);
        dateRange.addListener(this.dateRangeListener);
    }

    @Override
    public Date getFrom() {
        return this.getDateRange().getFrom();
    }

    public void setFrom(Date date) {
        DateRange dateRange = this.getDateRange();
        dateRange.removeListener(this.dateRangeListener);
        dateRange.setFrom(date);
        dateRange.addListener(this.dateRangeListener);
    }

    @Override
    public Date getTo() {
        return this.getDateRange().getTo();
    }

    public void setTo(Date date) {
        DateRange dateRange = this.getDateRange();
        dateRange.removeListener(this.dateRangeListener);
        dateRange.setTo(date);
        dateRange.addListener(this.dateRangeListener);
    }

    @Override
    protected void doLayout(Component container) {
        if (this.selectType) {
            this.addShortNameSelector(container);
        }
        this.addStatusSelector(container);
        this.addDateRange(container);
    }

    @Override
    protected ResultSet<T> createResultSet(SortConstraint[] sort) {
        return new ActResultSet(this.getArchetypeConstraint(), this.getParticipantConstraint(), this.getFrom(), this.getTo(), this.getStatuses(), this.excludeStatuses(), this.getConstraints(), this.getMaxResults(), sort);
    }

    protected void addDateRange(Component container) {
        DateRange range = this.getDateRange();
        container.add(range.getComponent());
        if (container instanceof Grid) {
            GridLayoutData layoutData = new GridLayoutData();
            layoutData.setColumnSpan(2);
            range.getComponent().setLayoutData((LayoutData)layoutData);
        }
        this.getFocusGroup().add(range.getFocusGroup());
    }

    protected DateRange getDateRange() {
        if (this.dateRange == null) {
            this.dateRange = this.createDateRange();
            this.dateRange.getComponent();
            this.dateRange.addListener(this.dateRangeListener);
        }
        return this.dateRange;
    }

    protected DateRange createDateRange() {
        return new DateRange();
    }
}

