/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Extent;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.EmptyResultSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryException;
import org.openvpms.web.component.im.query.QueryListener;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuery<T>
implements Query<T> {
    private final Class<T> type;
    private final String[] shortNames;
    private final ArchetypeService service;
    private final List<QueryListener> listeners = new ArrayList<QueryListener>();
    private String name;
    private boolean contains;
    private boolean auto;
    private int valueMinLength;
    private boolean distinct;
    private int maxResults = 20;
    private SortConstraint[] sort;
    private IConstraint constraints;
    private static final Logger log = LoggerFactory.getLogger(AbstractQuery.class);

    public AbstractQuery(String[] shortNames, Class<T> type) {
        this(shortNames, true, type);
    }

    public AbstractQuery(String[] shortNames, boolean primaryOnly, Class<T> type) {
        Class<?> actual;
        this.service = ServiceHelper.getArchetypeService();
        this.shortNames = DescriptorHelper.getShortNames((String[])shortNames, (boolean)primaryOnly, (ArchetypeService)this.service);
        this.type = type;
        if (IMObject.class.isAssignableFrom(type) && !type.isAssignableFrom(actual = IMObjectHelper.getType(this.shortNames))) {
            throw new QueryException(QueryException.ErrorCode.InvalidType, type, actual);
        }
    }

    public AbstractQuery(String[] shortNames, boolean primaryOnly) {
        this.service = ServiceHelper.getArchetypeService();
        this.shortNames = DescriptorHelper.getShortNames((String[])shortNames, (boolean)primaryOnly, (ArchetypeService)this.service);
        this.type = IMObjectHelper.getType(this.shortNames);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public void setDefaultSortConstraint(SortConstraint[] sort) {
        this.sort = sort;
    }

    @Override
    public SortConstraint[] getDefaultSortConstraint() {
        return this.sort;
    }

    @Override
    public ResultSet<T> query() {
        return this.query(this.sort);
    }

    @Override
    public boolean selects(T object) {
        long start = System.currentTimeMillis();
        for (T next : this) {
            if (!next.equals(object)) continue;
            return true;
        }
        long end = System.currentTimeMillis();
        if (end - start > 1000L) {
            log.warn("Slow query: " + this.getClass().getName() + " performing linear search");
        }
        return false;
    }

    @Override
    public Iterator<T> iterator(SortConstraint[] sort) {
        ResultSet set = this.query(sort);
        if (set == null) {
            set = new EmptyResultSet(10);
        }
        return new ResultSetIterator(set);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.sort);
    }

    @Override
    public String[] getShortNames() {
        return this.shortNames;
    }

    @Override
    public void setValue(String value) {
        this.name = value;
    }

    @Override
    public String getValue() {
        return this.name;
    }

    @Override
    public void setContains(boolean contains) {
        this.contains = contains;
    }

    @Override
    public boolean isContains() {
        return this.contains;
    }

    @Override
    public void setValueMinLength(int length) {
        this.valueMinLength = length;
    }

    @Override
    public int getValueMinLength() {
        return this.valueMinLength;
    }

    @Override
    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    @Override
    public boolean isAuto() {
        return this.auto;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setConstraints(IConstraint constraints) {
        this.constraints = constraints;
    }

    public IConstraint getConstraints() {
        return this.constraints;
    }

    @Override
    public QueryState getQueryState() {
        return null;
    }

    @Override
    public void setQueryState(QueryState state) {
    }

    @Override
    public Extent getHeight() {
        return this.getHeight(1);
    }

    protected void onQuery() {
        QueryListener[] listeners;
        for (QueryListener listener : listeners = this.listeners.toArray(new QueryListener[0])) {
            listener.query();
        }
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    protected Extent getHeight(int factor) {
        int height = StyleSheetHelper.getProperty((String)"query.height", (int)-1);
        return height > 0 ? new Extent(height * factor) : null;
    }
}

